/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.commands;

import java.util.Collections;
import java.util.List;
import me.deecaad.core.commands.CommandPermission;
import me.deecaad.core.commands.SubCommand;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@CommandPermission(permission="weaponmechanics.commands.give")
@Deprecated
public class LegacyGiveCommand
extends SubCommand {
    public LegacyGiveCommand() {
        super("wm", "give", "Gives a given number of weapons to a given player", "<weapon> <amount> <player>");
        this.setAliases(Collections.singletonList("get"));
    }

    public void execute(CommandSender sender, String[] args) {
        Player player;
        if (args.length == 0 || args.length > 3) {
            sender.sendMessage(this.toString());
            return;
        }
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        String weaponTitle = info.getWeaponTitle(args[0]);
        if (!WeaponMechanics.getWeaponHandler().getInfoHandler().hasWeapon(weaponTitle)) {
            sender.sendMessage(ChatColor.RED + "Could not find weapon " + args[0]);
            return;
        }
        int amount = 1;
        if (args.length > 1) {
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Tried to use amount which wasn't number " + args[1]);
                return;
            }
            if (amount < 0 || amount > 64) {
                sender.sendMessage(ChatColor.RED + "Tried to use amount which was less than 1 or more than 64");
                return;
            }
        }
        if (args.length > 2) {
            player = Bukkit.getPlayer((String)args[2]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find player " + args[2]);
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            sender.sendMessage(ChatColor.RED + "You can't give weapons for console, sorry. :(");
            return;
        }
        info.giveOrDropWeapon(info.getWeaponTitle(weaponTitle), (LivingEntity)player, amount);
    }

    public List<String> handleCustomTag(String[] args, String current) {
        return switch (current) {
            case "<weapon>" -> WeaponMechanics.getWeaponHandler().getInfoHandler().getSortedWeaponList();
            default -> super.handleCustomTag(args, current);
        };
    }
}

