/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics;

import java.util.Set;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.ICompatibility;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.compatibility.IWeaponCompatibility;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.damage.BlockDamageData;
import me.deecaad.weaponmechanics.weapon.projectile.AProjectile;
import me.deecaad.weaponmechanics.weapon.projectile.ProjectilesRunnable;
import me.deecaad.weaponmechanics.weapon.reload.ammo.Ammo;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConfig;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoRegistry;
import me.deecaad.weaponmechanics.weapon.reload.ammo.IAmmoType;
import me.deecaad.weaponmechanics.weapon.reload.ammo.ItemAmmo;
import me.deecaad.weaponmechanics.weapon.shoot.FullAutoTask;
import me.deecaad.weaponmechanics.weapon.skin.SkinHandler;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import me.deecaad.weaponmechanics.wrappers.StatsData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WeaponMechanicsAPI {
    private WeaponMechanicsAPI() {
    }

    @Nullable
    public static StatsData getStats(@NotNull Player player) {
        return WeaponMechanics.getPlayerWrapper(player).getStatsData();
    }

    @NotNull
    public static String getSkinFor(@NotNull Player player, @NotNull ItemStack weaponStack) {
        String weaponTitle = WeaponMechanicsAPI.getWeaponTitle(weaponStack);
        if (weaponTitle == null) {
            throw new IllegalArgumentException("Item is not a weapon");
        }
        SkinSelector skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class);
        if (skins == null) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not use skins");
        }
        String skinOverride = CustomTag.WEAPON_SKIN.getString(weaponStack);
        if (skinOverride != null) {
            return skinOverride;
        }
        StatsData stats = WeaponMechanics.getPlayerWrapper(player).getStatsData();
        if (stats == null) {
            return "default";
        }
        String skin = (String)stats.get(weaponTitle, WeaponStat.SKIN, null);
        if (skin == null) {
            return "default";
        }
        if (!"default".equals(skin) && !skins.getCustomSkins().contains(skin)) {
            return "default";
        }
        return skin;
    }

    public static void setSkin(@NotNull ItemStack weaponStack, @Nullable String skin) {
        String weaponTitle;
        if (skin == null) {
            skin = "default";
        }
        if ((weaponTitle = WeaponMechanicsAPI.getWeaponTitle(weaponStack)) == null) {
            throw new IllegalArgumentException("Item is not a weapon");
        }
        SkinSelector skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class);
        if (skins == null) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not use skins");
        }
        if (!"default".equals(skin) && !skins.getCustomSkins().contains(skin)) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not have skin " + skin);
        }
        CustomTag.WEAPON_SKIN.setString(weaponStack, skin);
    }

    public static boolean setSkin(@NotNull Player player, @NotNull String weaponTitle, @Nullable String skin) {
        SkinSelector skins;
        if (!WeaponMechanics.getWeaponHandler().getInfoHandler().hasWeapon(weaponTitle)) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not exist");
        }
        if (skin == null) {
            skin = "default";
        }
        if ((skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class)) == null) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not use skins");
        }
        if (!"default".equals(skin) && !skins.getCustomSkins().contains(skin)) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not have skin " + skin);
        }
        PlayerWrapper wrapper = WeaponMechanics.getPlayerWrapper(player);
        StatsData stats = wrapper.getStatsData();
        if (stats == null) {
            return false;
        }
        stats.set(weaponTitle, WeaponStat.SKIN, skin);
        if (Bukkit.getPluginManager().isPluginEnabled("WeaponMechanicsCosmetics")) {
            ItemStack offHand;
            SkinHandler skinHandler = WeaponMechanics.getWeaponHandler().getSkinHandler();
            EntityEquipment equipment = player.getEquipment();
            if (equipment == null) {
                return true;
            }
            ItemStack mainHand = equipment.getItemInMainHand();
            if (weaponTitle.equals(WeaponMechanicsAPI.getWeaponTitle(mainHand))) {
                skinHandler.tryUse(wrapper, weaponTitle, mainHand, EquipmentSlot.HAND);
            }
            if (weaponTitle.equals(WeaponMechanicsAPI.getWeaponTitle(offHand = equipment.getItemInOffHand()))) {
                skinHandler.tryUse(wrapper, weaponTitle, offHand, EquipmentSlot.OFF_HAND);
            }
        }
        return true;
    }

    @NotNull
    public static Set<String> getCustomSkins(@NotNull String weaponTitle) {
        SkinSelector skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class);
        if (skins == null) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not use skins");
        }
        return skins.getCustomSkins();
    }

    public static boolean setFullAutoShotsPerSecond(@NotNull LivingEntity entity, int shotsPerSecond) {
        EntityWrapper wrapper = WeaponMechanics.getEntityWrapper(entity, true);
        if (wrapper == null) {
            return true;
        }
        if (WeaponMechanicsAPI.setFullAutoShotsPerSecond(wrapper.getMainHandData(), shotsPerSecond)) {
            return true;
        }
        return WeaponMechanicsAPI.setFullAutoShotsPerSecond(wrapper.getOffHandData(), shotsPerSecond);
    }

    public static boolean setFullAutoShotsPerSecond(@NotNull HandData hand, int shotsPerSecond) {
        FullAutoTask fullAutoTask = hand.getFullAutoTask();
        if (fullAutoTask == null) {
            return false;
        }
        if (shotsPerSecond <= 0) {
            hand.getFullAutoTask().cancel();
            hand.setFullAutoTask(null, 0);
            return true;
        }
        fullAutoTask.setPerShot(shotsPerSecond / 20);
        fullAutoTask.setRate(shotsPerSecond % 20);
        return true;
    }

    public static double getScopeLevel(@NotNull LivingEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Expected an entity, got null");
        }
        EntityWrapper wrapper = WeaponMechanics.getEntityWrapper(entity, true);
        if (wrapper == null) {
            return 0.0;
        }
        return Math.max(wrapper.getMainHandData().getZoomData().getZoomAmount(), wrapper.getOffHandData().getZoomData().getZoomAmount());
    }

    public static boolean isScoping(@NotNull LivingEntity entity) {
        return WeaponMechanicsAPI.getScopeLevel(entity) != 0.0;
    }

    public static boolean isReloading(@NotNull LivingEntity entity) {
        EntityWrapper wrapper = WeaponMechanics.getEntityWrapper(entity, true);
        if (wrapper == null) {
            return false;
        }
        return wrapper.getMainHandData().isReloading() || wrapper.getOffHandData().isReloading();
    }

    @NotNull
    public static ItemStack generateWeapon(@NotNull String weaponTitle) {
        return WeaponMechanics.getWeaponHandler().getInfoHandler().generateWeapon(weaponTitle, 1);
    }

    public static void giveWeapon(@NotNull String weaponTitle, @NotNull Player player) {
        WeaponMechanics.getWeaponHandler().getInfoHandler().giveOrDropWeapon(weaponTitle, (LivingEntity)player, 1);
    }

    public static void addProjectile(@NotNull AProjectile projectile) {
        ProjectilesRunnable runnable = WeaponMechanics.getProjectilesRunnable();
        runnable.addProjectile(projectile);
    }

    public static boolean isBroken(@NotNull Block block) {
        return BlockDamageData.isBroken(block);
    }

    public static void regenerateAllBlocks() {
        BlockDamageData.regenerateAll();
    }

    @Nullable
    public static String getWeaponTitle(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        return CustomTag.WEAPON_TITLE.getString(item);
    }

    @Nullable
    public static Ammo getCurrentAmmo(@NotNull ItemStack weaponStack) {
        String weaponTitle = WeaponMechanicsAPI.getWeaponTitle(weaponStack);
        AmmoConfig ammo = (AmmoConfig)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Reload.Ammo", AmmoConfig.class);
        if (ammo == null) {
            return null;
        }
        return ammo.getCurrentAmmo(weaponStack);
    }

    @Nullable
    public static ItemStack generateAmmo(@NotNull String ammoTitle, boolean magazine) {
        Ammo ammo = (Ammo)AmmoRegistry.AMMO_REGISTRY.get(ammoTitle);
        if (ammo == null) {
            return null;
        }
        IAmmoType iAmmoType = ammo.getType();
        if (iAmmoType instanceof ItemAmmo) {
            ItemAmmo itemAmmo = (ItemAmmo)iAmmoType;
            return magazine ? itemAmmo.getMagazineItem() : itemAmmo.getBulletItem();
        }
        return null;
    }

    public static void shoot(@NotNull LivingEntity shooter, @NotNull String weaponTitle, @NotNull Location target) {
        WeaponMechanicsAPI.shoot(shooter, weaponTitle, target.toVector().subtract(shooter.getEyeLocation().toVector()));
    }

    public static void shoot(@NotNull LivingEntity shooter, @NotNull String weaponTitle) {
        WeaponMechanicsAPI.shoot(shooter, weaponTitle, shooter.getLocation().getDirection());
    }

    public static void shoot(@NotNull LivingEntity shooter, @NotNull String weaponTitle, @NotNull Vector direction) {
        if (!WeaponMechanics.getWeaponHandler().getInfoHandler().hasWeapon(weaponTitle)) {
            throw new IllegalArgumentException("Weapon " + weaponTitle + " does not exist");
        }
        WeaponMechanics.getWeaponHandler().getShootHandler().shoot(shooter, weaponTitle, direction.clone().normalize());
    }

    @NotNull
    public static ICompatibility getCompatibility() {
        return CompatibilityAPI.getCompatibility();
    }

    @NotNull
    public static IWeaponCompatibility getWeaponCompatibility() {
        return WeaponCompatibilityAPI.getWeaponCompatibility();
    }

    @NotNull
    public static Plugin getPluginInstance() {
        return WeaponMechanics.getPlugin();
    }

    @NotNull
    public static WeaponMechanics getInstance() {
        return WeaponMechanics.getInstance();
    }
}

