/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketListener;
import com.jeff_media.updatechecker.UpdateCheckSource;
import com.jeff_media.updatechecker.UpdateChecker;
import com.jeff_media.updatechecker.UserAgentBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.MainCommand;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.worldguard.WorldGuardCompatibility;
import me.deecaad.core.database.Database;
import me.deecaad.core.database.MySQL;
import me.deecaad.core.database.SQLite;
import me.deecaad.core.events.QueueSerializerEvent;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.DuplicateKeyException;
import me.deecaad.core.file.FileReader;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.JarInstancer;
import me.deecaad.core.file.JarSearcher;
import me.deecaad.core.file.LinkedConfig;
import me.deecaad.core.file.SerializerInstancer;
import me.deecaad.core.file.TaskChain;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.mechanics.Registry;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.placeholder.PlaceholderHandler;
import me.deecaad.core.utils.Debugger;
import me.deecaad.core.utils.FileUtil;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.commands.WeaponMechanicsCommand;
import me.deecaad.weaponmechanics.commands.WeaponMechanicsMainCommand;
import me.deecaad.weaponmechanics.lib.MythicMobsLoader;
import me.deecaad.weaponmechanics.listeners.ExplosionInteractionListeners;
import me.deecaad.weaponmechanics.listeners.RepairItemListener;
import me.deecaad.weaponmechanics.listeners.ResourcePackListener;
import me.deecaad.weaponmechanics.listeners.WeaponListeners;
import me.deecaad.weaponmechanics.listeners.trigger.TriggerEntityListeners;
import me.deecaad.weaponmechanics.listeners.trigger.TriggerPlayerListeners;
import me.deecaad.weaponmechanics.packetlisteners.OutAbilitiesListener;
import me.deecaad.weaponmechanics.packetlisteners.OutEntityEffectListener;
import me.deecaad.weaponmechanics.packetlisteners.OutRemoveEntityEffectListener;
import me.deecaad.weaponmechanics.packetlisteners.OutSetSlotBobFix;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.damage.AssistData;
import me.deecaad.weaponmechanics.weapon.damage.BlockDamageData;
import me.deecaad.weaponmechanics.weapon.damage.DamageModifier;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import me.deecaad.weaponmechanics.weapon.placeholders.PlaceholderValidator;
import me.deecaad.weaponmechanics.weapon.projectile.HitBoxValidator;
import me.deecaad.weaponmechanics.weapon.projectile.ProjectilesRunnable;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoRegistry;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.Recoil;
import me.deecaad.weaponmechanics.weapon.stats.PlayerStat;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class WeaponMechanics {
    private static WeaponMechanics plugin;
    JavaPlugin javaPlugin;
    Map<LivingEntity, EntityWrapper> entityWrappers;
    Configuration configurations;
    Configuration basicConfiguration;
    MainCommand mainCommand;
    WeaponHandler weaponHandler;
    ResourcePackListener resourcePackListener;
    ProjectilesRunnable projectilesRunnable;
    ProtocolManager protocolManager;
    Metrics metrics;
    Database database;
    public static Debugger debug;

    public WeaponMechanics(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    public org.bukkit.configuration.Configuration getConfig() {
        return this.javaPlugin.getConfig();
    }

    public Logger getLogger() {
        return this.javaPlugin.getLogger();
    }

    public File getDataFolder() {
        return this.javaPlugin.getDataFolder();
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)ReflectionUtil.invokeMethod((Method)ReflectionUtil.getMethod(JavaPlugin.class, (String)"getClassLoader", (Class[])new Class[0]), (Object)this.javaPlugin, (Object[])new Object[0]);
    }

    public File getFile() {
        return (File)ReflectionUtil.invokeMethod((Method)ReflectionUtil.getMethod(JavaPlugin.class, (String)"getFile", (Class[])new Class[0]), (Object)this.javaPlugin, (Object[])new Object[0]);
    }

    public void onLoad() {
        this.setupDebugger();
        WorldGuardCompatibility guard = CompatibilityAPI.getWorldGuardCompatibility();
        if (guard.isInstalled()) {
            debug.info(new String[]{"Detected WorldGuard, registering flags"});
            guard.registerFlag("weapon-shoot", WorldGuardCompatibility.FlagType.STATE_FLAG);
            guard.registerFlag("weapon-shoot-message", WorldGuardCompatibility.FlagType.STRING_FLAG);
            guard.registerFlag("weapon-explode", WorldGuardCompatibility.FlagType.STATE_FLAG);
            guard.registerFlag("weapon-explode-message", WorldGuardCompatibility.FlagType.STRING_FLAG);
            guard.registerFlag("weapon-break-block", WorldGuardCompatibility.FlagType.STATE_FLAG);
            guard.registerFlag("weapon-damage", WorldGuardCompatibility.FlagType.STATE_FLAG);
            guard.registerFlag("weapon-damage-message", WorldGuardCompatibility.FlagType.STRING_FLAG);
        } else {
            debug.debug(new String[]{"No WorldGuard detected!"});
        }
        try {
            JarSearcher searcher = new JarSearcher(new JarFile(this.getFile()));
            searcher.findAllSubclasses(Mechanic.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(arg_0 -> ((Registry)Mechanics.MECHANICS).add(arg_0));
            searcher.findAllSubclasses(Targeter.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(arg_0 -> ((Registry)Mechanics.TARGETERS).add(arg_0));
            searcher.findAllSubclasses(Condition.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(arg_0 -> ((Registry)Mechanics.CONDITIONS).add(arg_0));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void onEnable() {
        long millisCurrent = System.currentTimeMillis();
        plugin = this;
        this.entityWrappers = new HashMap<LivingEntity, EntityWrapper>();
        this.writeFiles();
        this.registerPacketListeners();
        this.weaponHandler = new WeaponHandler();
        this.projectilesRunnable = new ProjectilesRunnable(WeaponMechanics.getPlugin());
        this.resourcePackListener = new ResourcePackListener();
        Recoil.MILLIS_BETWEEN_ROTATIONS = this.basicConfiguration.getInt("Recoil_Millis_Between_Rotations", 20);
        this.setupDatabase();
        this.registerPlaceholders();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
            this.weaponHandler.getStatsHandler().load(playerWrapper);
        }
        new TaskChain((Plugin)this.javaPlugin).thenRunSync(() -> {
            this.loadConfig();
            this.registerListeners();
            this.registerBStats();
            this.registerPermissions();
        });
        this.registerCommands();
        this.registerUpdateChecker();
        long tookMillis = System.currentTimeMillis() - millisCurrent;
        debug.debug(new String[]{"Enabled WeaponMechanics in " + NumberUtil.toTime((int)((int)(tookMillis / 1000L))) + "s"});
        if (Bukkit.getPluginManager().getPlugin("WeaponMechanicsCosmetics") == null) {
            debug.info(new String[]{"Buy WeaponMechanicsCosmetics to support our development: https://www.spigotmc.org/resources/104539/"});
        }
        if (Bukkit.getPluginManager().getPermission("Vivecraft_Spigot_Extensions") != null) {
            debug.warn(new String[]{"Detected 'Vivecraft_Spigot_Extensions' on your server"});
            debug.warn(new String[]{"For better compatibility with WeaponMechanics, we recommend switching to VivecraftSpigot"});
            debug.warn(new String[]{"VivecraftSpigot: https://www.spigotmc.org/resources/104539/"});
        }
        debug.start(WeaponMechanics.getPlugin());
    }

    void setupDebugger() {
        Logger logger = this.getLogger();
        int level = this.getConfig().getInt("Debug_Level", 2);
        boolean isPrintTraces = this.getConfig().getBoolean("Print_Traces", false);
        debug = new Debugger(logger, level, isPrintTraces);
        MechanicsCore.debug.setLevel(level);
        WeaponMechanics.debug.permission = "weaponmechanics.errorlog";
        WeaponMechanics.debug.msg = "WeaponMechanics had %s error(s) in console.";
    }

    void writeFiles() {
        debug.debug(new String[]{"Writing files and filling basic configuration"});
        if (!this.getDataFolder().exists() || this.getDataFolder().listFiles() == null || this.getDataFolder().listFiles().length == 0) {
            debug.info(new String[]{"Copying files from jar (This process may take up to 30 seconds during the first load!)"});
            FileUtil.copyResourcesTo((URL)this.getClassLoader().getResource("WeaponMechanics"), (Path)this.getDataFolder().toPath());
        }
        try {
            FileUtil.ensureDefaults((URL)this.getClassLoader().getResource("WeaponMechanics/config.yml"), (File)new File(this.getDataFolder(), "config.yml"));
        }
        catch (YAMLException e) {
            debug.error(new String[]{"WeaponMechanics jar corruption... This is most likely caused by using /reload after building jar!"});
        }
        File configyml = new File(this.getDataFolder(), "config.yml");
        if (configyml.exists()) {
            ArrayList<Object> validators = new ArrayList<Object>();
            validators.add(new HitBoxValidator());
            validators.add(new PlaceholderValidator());
            validators.add(new AssistData());
            FileReader basicConfigurationReader = new FileReader(debug, List.of(new DamageModifier()), validators);
            Configuration filledMap = basicConfigurationReader.fillOneFile(configyml);
            this.basicConfiguration = basicConfigurationReader.usePathToSerializersAndValidators(filledMap);
        } else {
            this.basicConfiguration = new LinkedConfig();
            debug.log(LogLevel.WARN, new String[]{"Could not locate config.yml?", "Make sure it exists in path " + this.getDataFolder() + "/config.yml"});
        }
        if (this.basicConfiguration.getBool("Resource_Pack_Download.Enabled")) {
            new TaskChain(WeaponMechanics.getPlugin()).thenRunAsync(data -> {
                File pack;
                Object link = this.basicConfiguration.getString("Resource_Pack_Download.Link");
                int connection = this.basicConfiguration.getInt("Resource_Pack_Download.Connection_Timeout");
                int read = this.basicConfiguration.getInt("Resource_Pack_Download.Read_Timeout");
                if ("https://raw.githubusercontent.com/WeaponMechanics/MechanicsMain/master/WeaponMechanicsResourcePack.zip".equals(link)) {
                    try {
                        link = "https://raw.githubusercontent.com/WeaponMechanics/MechanicsMain/master/resourcepack/WeaponMechanicsResourcePack-" + this.resourcePackListener.getResourcePackVersion() + ".zip";
                    }
                    catch (InternalError e) {
                        debug.log(LogLevel.DEBUG, "Failed to fetch resource pack version due to timeout", (Throwable)e);
                        return null;
                    }
                }
                if (!(pack = new File(this.getDataFolder(), "WeaponMechanicsResourcePack.zip")).exists()) {
                    FileUtil.downloadFile((File)pack, (String)link, (int)connection, (int)read);
                }
                return null;
            });
        }
    }

    void setupDatabase() {
        if (this.basicConfiguration.getBool("Database.Enable", true)) {
            debug.debug(new String[]{"Setting up database"});
            if (this.basicConfiguration.getString("Database.Type", "SQLITE").equals("SQLITE")) {
                String absolutePath = this.basicConfiguration.getString("Database.SQLite.Absolute_Path", "plugins/WeaponMechanics/weaponmechanics.db");
                try {
                    this.database = new SQLite(absolutePath);
                }
                catch (IOException | SQLException e) {
                    debug.log(LogLevel.WARN, "Failed to initialized database!", (Throwable)e);
                }
            } else {
                String hostname = this.basicConfiguration.getString("Database.MySQL.Hostname", "localhost");
                int port = this.basicConfiguration.getInt("Database.MySQL.Port", 3306);
                String databaseName = this.basicConfiguration.getString("Database.MySQL.Database", "weaponmechanics");
                String username = this.basicConfiguration.getString("Database.MySQL.Username", "root");
                String password = this.basicConfiguration.getString("Database.MySQL.Password", "");
                this.database = new MySQL(hostname, port, databaseName, username, password);
            }
            this.database.executeUpdate(true, new String[]{PlayerStat.getCreateTableString(), WeaponStat.getCreateTableString()});
        }
    }

    void loadConfig() {
        debug.debug(new String[]{"Loading and serializing config"});
        if (this.configurations == null) {
            this.configurations = new LinkedConfig();
        } else {
            this.configurations.clear();
        }
        List validators = null;
        try {
            validators = new JarInstancer(new JarFile(this.getFile())).createAllInstances(IValidator.class, this.getClassLoader(), true, new Class[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AmmoRegistry.init();
        try {
            QueueSerializerEvent event = new QueueSerializerEvent(this.javaPlugin, this.getDataFolder());
            event.addSerializers((Collection)new SerializerInstancer(new JarFile(this.getFile())).createAllInstances(this.getClassLoader(), new Class[0]));
            event.addValidators((Collection)validators);
            Bukkit.getPluginManager().callEvent((Event)event);
            Configuration temp = new FileReader(debug, event.getSerializers(), event.getValidators()).fillAllFiles(this.getDataFolder(), new String[]{"config.yml", "repair_kits", "attachments", "ammos", "placeholders"});
            this.configurations.add(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DuplicateKeyException e) {
            debug.error(new String[]{"Error loading config: " + e.getMessage()});
        }
    }

    void registerPlaceholders() {
        debug.debug(new String[]{"Registering placeholders"});
        try {
            new JarInstancer(new JarFile(this.getFile())).createAllInstances(PlaceholderHandler.class, this.getClassLoader(), true, new Class[0]).forEach(arg_0 -> ((Registry)PlaceholderHandler.REGISTRY).add(arg_0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void registerListeners() {
        debug.debug(new String[]{"Registering listeners"});
        Bukkit.getPluginManager().registerEvents((Listener)new TriggerPlayerListeners(this.weaponHandler), WeaponMechanics.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)new TriggerEntityListeners(this.weaponHandler), WeaponMechanics.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)new WeaponListeners(this.weaponHandler), WeaponMechanics.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)new ExplosionInteractionListeners(), WeaponMechanics.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.resourcePackListener, WeaponMechanics.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)RepairItemListener.getInstance(), WeaponMechanics.getPlugin());
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            PluginDescriptionFile desc = Bukkit.getPluginManager().getPlugin("MythicMobs").getDescription();
            if (!desc.getVersion().split("\\.")[0].contains("5")) {
                debug.warn(new String[]{"Could not hook into MythicMobs because it is outdated"});
            } else {
                Bukkit.getPluginManager().registerEvents((Listener)new MythicMobsLoader(), WeaponMechanics.getPlugin());
                debug.info(new String[]{"Hooked in MythicMobs " + desc.getVersion()});
            }
        }
    }

    void registerPacketListeners() {
        debug.debug(new String[]{"Creating packet listeners"});
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.protocolManager.addPacketListener((PacketListener)new OutAbilitiesListener((Plugin)this.javaPlugin));
        this.protocolManager.addPacketListener((PacketListener)new OutEntityEffectListener((Plugin)this.javaPlugin));
        this.protocolManager.addPacketListener((PacketListener)new OutRemoveEntityEffectListener((Plugin)this.javaPlugin));
        this.protocolManager.addPacketListener((PacketListener)new OutSetSlotBobFix((Plugin)this.javaPlugin));
    }

    void registerCommands() {
        debug.debug(new String[]{"Registering commands"});
        if (ReflectionUtil.getMCVersion() >= 13) {
            WeaponMechanicsCommand.build();
            return;
        }
        Method getCommandMap = ReflectionUtil.getMethod((Class)ReflectionUtil.getCBClass((String)"CraftServer"), (String)"getCommandMap", (Class[])new Class[0]);
        SimpleCommandMap commands = (SimpleCommandMap)ReflectionUtil.invokeMethod((Method)getCommandMap, (Object)Bukkit.getServer(), (Object[])new Object[0]);
        Command registered = commands.getCommand("weaponmechanics");
        if (registered != null) {
            try {
                this.mainCommand = (MainCommand)registered;
            }
            catch (ClassCastException ex) {
                debug.error(new String[]{"/weaponmechanics command was already registered... does another plugin use /wm?", "The registered command: " + registered, "Do not ignore this error! The weapon mechanics commands will not work at all!"});
            }
        } else {
            this.mainCommand = new WeaponMechanicsMainCommand();
            commands.register("weaponmechanics", (Command)this.mainCommand);
        }
    }

    void registerPermissions() {
        debug.debug(new String[]{"Registering permissions"});
        Permission parent = Bukkit.getPluginManager().getPermission("weaponmechanics.use.*");
        if (parent == null) {
            new TaskChain((Plugin)this.javaPlugin).thenRunSync(this::registerPermissions);
            return;
        }
        for (String weaponTitle : this.weaponHandler.getInfoHandler().getSortedWeaponList()) {
            String permissionName = "weaponmechanics.use." + weaponTitle;
            Permission permission = Bukkit.getPluginManager().getPermission(permissionName);
            if (permission == null) {
                permission = new Permission(permissionName, "Permission to use " + weaponTitle);
                Bukkit.getPluginManager().addPermission(permission);
            }
            permission.addParent(parent, true);
        }
    }

    void registerUpdateChecker() {
        if (!this.basicConfiguration.getBool("Update_Checker.Enable", true)) {
            return;
        }
        debug.debug(new String[]{"Registering update checker"});
        new UpdateChecker(this.javaPlugin, UpdateCheckSource.SPIGOT, "99913").setNotifyOpsOnJoin(true).setUserAgent(new UserAgentBuilder().addPluginNameAndVersion()).checkEveryXHours(24.0).checkNow();
    }

    void registerBStats() {
        if (this.metrics != null) {
            return;
        }
        debug.debug(new String[]{"Registering bStats"});
        int id = 14323;
        this.metrics = new Metrics((JavaPlugin)WeaponMechanics.getPlugin(), id);
        this.metrics.addCustomChart((CustomChart)new SimplePie("registered_weapons", () -> {
            int weapons = WeaponMechanics.getWeaponHandler().getInfoHandler().getSortedWeaponList().size();
            if (weapons <= 10) {
                return "0-10";
            }
            if (weapons <= 20) {
                return "11-20";
            }
            if (weapons <= 30) {
                return "21-30";
            }
            if (weapons <= 50) {
                return "31-50";
            }
            if (weapons <= 100) {
                return "51-100";
            }
            return ">100";
        }));
        this.metrics.addCustomChart((CustomChart)new SimplePie("custom_weapons", () -> {
            HashSet<String> defaultWeapons = new HashSet<String>(Arrays.asList("AK_47", "FN_FAL", "FR_5_56", "M4A1", "Stim", "Airstrike", "Cluster_Grenade", "Flashbang", "Grenade", "Semtex", "MG34", "Kar98k", "Combat_Knife", "50_GS", "357_Magnum", "RPG-7", "RPG_7", "Origin_12", "R9-0", "R9_0", "AX-50", "AX_50", "AUG", "Uzi"));
            InfoHandler infoHandler = WeaponMechanics.getWeaponHandler().getInfoHandler();
            int counter = 0;
            for (String weapon : infoHandler.getSortedWeaponList()) {
                if (defaultWeapons.contains(weapon)) continue;
                ++counter;
            }
            if (counter <= 0) {
                return "0";
            }
            if (counter <= 5) {
                return "1-5";
            }
            if (counter <= 10) {
                return "6-10";
            }
            if (counter <= 20) {
                return "11-20";
            }
            if (counter <= 30) {
                return "21-30";
            }
            if (counter <= 50) {
                return "31-50";
            }
            if (counter <= 100) {
                return "51-100";
            }
            return ">100";
        }));
        this.metrics.addCustomChart((CustomChart)new SimplePie("core_version", () -> MechanicsCore.getPlugin().getDescription().getVersion()));
    }

    public TaskChain onReload() {
        MechanicsCore mechanicsCore = MechanicsCore.getPlugin();
        this.onDisable();
        mechanicsCore.onDisable();
        mechanicsCore.onLoad();
        mechanicsCore.onEnable();
        plugin = this;
        this.setupDebugger();
        this.entityWrappers = new HashMap<LivingEntity, EntityWrapper>();
        this.weaponHandler = new WeaponHandler();
        this.projectilesRunnable = new ProjectilesRunnable(WeaponMechanics.getPlugin());
        this.resourcePackListener = new ResourcePackListener();
        return new TaskChain(WeaponMechanics.getPlugin()).thenRunAsync(this::writeFiles).thenRunSync(() -> {
            this.loadConfig();
            this.registerPacketListeners();
            this.registerListeners();
            this.registerCommands();
            this.registerPermissions();
            this.registerUpdateChecker();
            this.setupDatabase();
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
                this.weaponHandler.getStatsHandler().load(playerWrapper);
            }
        });
    }

    public void onDisable() {
        BlockDamageData.regenerateAll();
        HandlerList.unregisterAll((Plugin)WeaponMechanics.getPlugin());
        Bukkit.getServer().getScheduler().cancelTasks(WeaponMechanics.getPlugin());
        if (this.database != null) {
            for (EntityWrapper entityWrapper : this.entityWrappers.values()) {
                if (!entityWrapper.isPlayer()) continue;
                this.weaponHandler.getStatsHandler().save((PlayerWrapper)entityWrapper, true);
            }
            try {
                this.database.close();
            }
            catch (SQLException e) {
                debug.log(LogLevel.WARN, "Couldn't close database properly...", (Throwable)e);
            }
        }
        this.protocolManager.removePacketListeners((Plugin)this.javaPlugin);
        this.database = null;
        this.weaponHandler = null;
        this.entityWrappers = null;
        this.mainCommand = null;
        this.configurations = null;
        this.basicConfiguration = null;
        this.projectilesRunnable = null;
        plugin = null;
        debug = null;
    }

    public static ProjectilesRunnable getProjectilesRunnable() {
        return WeaponMechanics.plugin.projectilesRunnable;
    }

    public static Plugin getPlugin() {
        return WeaponMechanics.plugin.javaPlugin;
    }

    public static WeaponMechanics getInstance() {
        return plugin;
    }

    public static EntityWrapper getEntityWrapper(LivingEntity entity) {
        if (entity.getType() == EntityType.PLAYER) {
            return WeaponMechanics.getPlayerWrapper((Player)entity);
        }
        return WeaponMechanics.getEntityWrapper(entity, false);
    }

    @Nullable
    public static EntityWrapper getEntityWrapper(LivingEntity entity, boolean noAutoAdd) {
        if (entity.getType() == EntityType.PLAYER) {
            return WeaponMechanics.getPlayerWrapper((Player)entity);
        }
        EntityWrapper wrapper = WeaponMechanics.plugin.entityWrappers.get(entity);
        if (wrapper == null) {
            if (noAutoAdd) {
                return null;
            }
            wrapper = new EntityWrapper(entity);
            WeaponMechanics.plugin.entityWrappers.put(entity, wrapper);
        }
        return wrapper;
    }

    public static PlayerWrapper getPlayerWrapper(Player player) {
        EntityWrapper wrapper = WeaponMechanics.plugin.entityWrappers.get(player);
        if (wrapper == null) {
            wrapper = new PlayerWrapper(player);
            WeaponMechanics.plugin.entityWrappers.put((LivingEntity)player, wrapper);
        }
        if (!(wrapper instanceof PlayerWrapper)) {
            throw new IllegalArgumentException("Tried to get PlayerWrapper from player which didn't have PlayerWrapper (only EntityWrapper)...?");
        }
        return (PlayerWrapper)wrapper;
    }

    public static void removeEntityWrapper(LivingEntity entity) {
        EntityWrapper oldWrapper = WeaponMechanics.plugin.entityWrappers.remove(entity);
        if (oldWrapper != null) {
            int oldMoveTask = oldWrapper.getMoveTaskId();
            if (oldMoveTask != 0) {
                Bukkit.getScheduler().cancelTask(oldMoveTask);
            }
            oldWrapper.getMainHandData().cancelTasks();
            oldWrapper.getOffHandData().cancelTasks();
        }
    }

    public static Configuration getConfigurations() {
        return WeaponMechanics.plugin.configurations;
    }

    public static Configuration getBasicConfigurations() {
        return WeaponMechanics.plugin.basicConfiguration;
    }

    public static MainCommand getMainCommand() {
        return WeaponMechanics.plugin.mainCommand;
    }

    public static WeaponHandler getWeaponHandler() {
        return WeaponMechanics.plugin.weaponHandler;
    }

    @Nullable
    public static Database getDatabase() {
        return WeaponMechanics.plugin.database;
    }
}

