/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics;

import java.lang.reflect.Field;
import java.util.LinkedList;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ReflectionUtil;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.map.MinecraftFont;

public class Tools {
    private final Object a = "before a";
    private static final Object b = "before b";

    public static void main(String[] args) {
        Tools.calculateStats(0.55, 0.79, 0.42, 0.51, 0.71, 0.75);
    }

    private static void calculateStats(double accuracy, double damage, double range, double firerate, double mobility, double control) {
        System.out.println("Accuracy: ");
        System.out.println("-> spread: " + NumberUtil.lerp((double)12.5, (double)0.0, (double)accuracy));
        System.out.println("-> spread image FOV: " + 30.0 * NumberUtil.lerp((double)1.25, (double)0.0, (double)accuracy));
        System.out.println("Damage:");
        System.out.println("-> generally: " + NumberUtil.lerp((double)-5.0, (double)15.0, (double)damage));
        System.out.println("-> armor: " + Math.round(NumberUtil.lerp((double)-2.0, (double)5.0, (double)damage)));
        System.out.println("Range (damage drop off): ");
        double damageDropOff = NumberUtil.lerp((double)-3.0, (double)-1.0, (double)range);
        System.out.println("-> Default: 10: " + damageDropOff + " 25: " + damageDropOff * 2.0 + " 50: " + damageDropOff * 3.0);
        System.out.println("-> Shotgun: 5: " + damageDropOff + " 10: " + damageDropOff * 2.5 + " 20: " + damageDropOff * 4.0);
        System.out.println("-> Sniper rifle, rocket launcher, marksman rifle: 0");
        System.out.println("Fire rate: ");
        System.out.println("-> full/semi auto: " + NumberUtil.lerp((double)-5.0, (double)20.0, (double)firerate));
        System.out.println("-> firearm actions/delay between shots: " + NumberUtil.lerp((double)20.0, (double)-5.0, (double)firerate));
        System.out.println("Mobility:");
        System.out.println("-> movement attribute: " + NumberUtil.lerp((double)-0.08, (double)0.025, (double)mobility));
        System.out.println("-> reload duration: " + Math.round(NumberUtil.lerp((double)140.0, (double)0.0, (double)mobility)));
        System.out.println("Control: ");
        System.out.println("-> Full auto: " + NumberUtil.lerp((double)10.0, (double)0.0, (double)control));
        System.out.println("-> Slow firing: " + NumberUtil.lerp((double)15.0, (double)5.0, (double)control));
    }

    private static void reflectionsTest() {
        Tools tools = new Tools();
        Field aField = ReflectionUtil.getField(Tools.class, (String)"a");
        System.out.println(ReflectionUtil.invokeField((Field)aField, (Object)tools));
        ReflectionUtil.setField((Field)aField, (Object)tools, (Object)"After a");
        System.out.println(ReflectionUtil.invokeField((Field)aField, (Object)tools));
        Field bField = ReflectionUtil.getField(Tools.class, (String)"b");
        System.out.println(ReflectionUtil.invokeField((Field)bField, null));
        ReflectionUtil.setField((Field)bField, null, (Object)"After a");
        System.out.println(ReflectionUtil.invokeField((Field)aField, null));
    }

    private static void entityHitBox() {
        EntityType[] types = EntityType.values();
        System.out.println("Entity_Hitboxes:");
        for (EntityType type : types) {
            if (!type.isAlive()) continue;
            System.out.println("  " + type.name() + ":");
            System.out.println("    Horizontal_Entity: false");
            System.out.println("    HEAD: 0.0");
            System.out.println("    BODY: 0.0");
            System.out.println("    ARMS: true");
            System.out.println("    LEGS: 0.0");
            System.out.println("    FEET: 0.0");
        }
    }

    private static void blockDamageData() {
        System.out.println("\n\n\n\n");
        System.out.print("blocks = [");
        for (Material mat : Material.values()) {
            if (mat.isLegacy() || !mat.isBlock() || mat.isAir()) continue;
            System.out.print("(\"" + mat.name() + "\", " + mat.getBlastResistance() + ", " + mat.getHardness() + ")");
            System.out.print(", ");
        }
        System.out.println("]\n\n\n\n");
    }

    private static void fontData() {
        String ALL_CHARS = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        for (int i = 0; i < " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u007f".length(); ++i) {
            char c = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u007f".charAt(i);
            System.out.println(c + ": " + MinecraftFont.Font.getChar(c).getWidth());
        }
        System.out.println();
        System.out.println("=============== /wm list (Page 1) ===============");
        System.out.println(MinecraftFont.Font.getWidth("================== WeaponMechanics =================="));
    }

    private static int countDifferentCharacters(LinkedList<Character> characters) {
        int[] table = Tools.mapToCharTable(characters.toString());
        int count = 0;
        for (int i : table) {
            ++count;
        }
        return count;
    }

    private static int[] mapToCharTable(String str) {
        int[] table = new int["abcdefghijklmnopqrstuvwxyz".length()];
        for (int i = 0; i < str.length(); ++i) {
            try {
                int n = Character.toLowerCase(str.charAt(i)) - 97;
                table[n] = table[n] + 1;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return table;
    }
}

