/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.exception;

import com.cjcrafter.openai.exception.InvalidRequestError;
import com.cjcrafter.openai.exception.UnknownError;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\b&\u0018\u0000 \u00112\u00060\u0001j\u0002`\u0002:\u0001\u0011B#\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB-\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/cjcrafter/openai/exception/OpenAIError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "param", "Lcom/google/gson/JsonElement;", "code", "", "message", "(Lcom/google/gson/JsonElement;Ljava/lang/String;Ljava/lang/String;)V", "cause", "", "(Lcom/google/gson/JsonElement;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lcom/google/gson/JsonElement;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCode", "()Ljava/lang/String;", "getParam", "()Lcom/google/gson/JsonElement;", "Companion", "ChatGPT-Java-API"})
public abstract class OpenAIError
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JsonElement param;
    @Nullable
    private final String code;

    @Nullable
    public final JsonElement getParam() {
        return this.param;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public OpenAIError(@Nullable JsonElement param, @Nullable String code, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
        this.param = param;
        this.code = code;
    }

    public OpenAIError(@Nullable JsonElement param, @Nullable String code, @NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, cause);
        this.param = param;
        this.code = code;
    }

    public OpenAIError(@Nullable JsonElement param, @Nullable String code, @Nullable Throwable cause) {
        super(cause);
        this.param = param;
        this.code = code;
    }

    @JvmStatic
    @NotNull
    public static final OpenAIError fromJson(@NotNull JsonObject json) {
        return Companion.fromJson(json);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/cjcrafter/openai/exception/OpenAIError$Companion;", "", "()V", "fromJson", "Lcom/cjcrafter/openai/exception/OpenAIError;", "json", "Lcom/google/gson/JsonObject;", "ChatGPT-Java-API"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenAIError fromJson(@NotNull JsonObject json) {
            OpenAIError openAIError;
            String code;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String message = json.get("message").getAsString();
            String type = json.get("type").isJsonNull() ? null : json.get("type").getAsString();
            JsonElement param = json.get("param").isJsonNull() ? null : json.get("param");
            String string = code = json.get("code").isJsonNull() ? null : json.get("code").getAsString();
            if (Intrinsics.areEqual((Object)json.get("type").getAsString(), (Object)"invalid_request_error")) {
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                openAIError = new InvalidRequestError(param, code, message);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                openAIError = new UnknownError(param, code, message, type);
            }
            return openAIError;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

