/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.completions;

import com.cjcrafter.openai.completions.CompletionChoiceChunk;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J\t\u0010#\u001a\u00020\u001cH\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/cjcrafter/openai/completions/CompletionResponseChunk;", "", "id", "", "created", "", "model", "choices", "", "Lcom/cjcrafter/openai/completions/CompletionChoiceChunk;", "(Ljava/lang/String;JLjava/lang/String;Ljava/util/List;)V", "getChoices", "()Ljava/util/List;", "getCreated", "()J", "getId", "()Ljava/lang/String;", "getModel", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "get", "index", "", "getTime", "Ljava/time/Instant;", "getZonedTime", "Ljava/time/ZonedDateTime;", "timezone", "Ljava/time/ZoneId;", "hashCode", "toString", "ChatGPT-Java-API"})
public final class CompletionResponseChunk {
    @NotNull
    private final String id;
    private final long created;
    @NotNull
    private final String model;
    @NotNull
    private final List<CompletionChoiceChunk> choices;

    public CompletionResponseChunk(@NotNull String id, long created, @NotNull String model, @NotNull List<CompletionChoiceChunk> choices) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        this.id = id;
        this.created = created;
        this.model = model;
        this.choices = choices;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getCreated() {
        return this.created;
    }

    @NotNull
    public final String getModel() {
        return this.model;
    }

    @NotNull
    public final List<CompletionChoiceChunk> getChoices() {
        return this.choices;
    }

    @NotNull
    public final Instant getTime() {
        Instant instant = Instant.ofEpochSecond(this.created);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(created)");
        return instant;
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime(@NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.getTime(), timezone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(getTime(), timezone)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getZonedTime$default(CompletionResponseChunk completionResponseChunk, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = TimeZone.getDefault().toZoneId();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"getDefault().toZoneId()");
            zoneId = zoneId2;
        }
        return completionResponseChunk.getZonedTime(zoneId);
    }

    @NotNull
    public final CompletionChoiceChunk get(int index) {
        return this.choices.get(index);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.created;
    }

    @NotNull
    public final String component3() {
        return this.model;
    }

    @NotNull
    public final List<CompletionChoiceChunk> component4() {
        return this.choices;
    }

    @NotNull
    public final CompletionResponseChunk copy(@NotNull String id, long created, @NotNull String model, @NotNull List<CompletionChoiceChunk> choices) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new CompletionResponseChunk(id, created, model, choices);
    }

    public static /* synthetic */ CompletionResponseChunk copy$default(CompletionResponseChunk completionResponseChunk, String string, long l, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = completionResponseChunk.id;
        }
        if ((n & 2) != 0) {
            l = completionResponseChunk.created;
        }
        if ((n & 4) != 0) {
            string2 = completionResponseChunk.model;
        }
        if ((n & 8) != 0) {
            list = completionResponseChunk.choices;
        }
        return completionResponseChunk.copy(string, l, string2, list);
    }

    @NotNull
    public String toString() {
        return "CompletionResponseChunk(id=" + this.id + ", created=" + this.created + ", model=" + this.model + ", choices=" + this.choices + ')';
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + this.model.hashCode();
        result = result * 31 + ((Object)this.choices).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompletionResponseChunk)) {
            return false;
        }
        CompletionResponseChunk completionResponseChunk = (CompletionResponseChunk)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)completionResponseChunk.id)) {
            return false;
        }
        if (this.created != completionResponseChunk.created) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.model, (Object)completionResponseChunk.model)) {
            return false;
        }
        return Intrinsics.areEqual(this.choices, completionResponseChunk.choices);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime() {
        return CompletionResponseChunk.getZonedTime$default(this, null, 1, null);
    }
}

