/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.chat;

import com.cjcrafter.openai.chat.ChatChoiceChunk;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J\t\u0010 \u001a\u00020\u0019H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/cjcrafter/openai/chat/ChatResponseChunk;", "", "id", "", "created", "", "choices", "", "Lcom/cjcrafter/openai/chat/ChatChoiceChunk;", "(Ljava/lang/String;JLjava/util/List;)V", "getChoices", "()Ljava/util/List;", "getCreated", "()J", "getId", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "get", "index", "", "getTime", "Ljava/time/Instant;", "getZonedTime", "Ljava/time/ZonedDateTime;", "timezone", "Ljava/time/ZoneId;", "hashCode", "toString", "update", "", "json", "Lcom/google/gson/JsonObject;", "update$ChatGPT_Java_API", "ChatGPT-Java-API"})
public final class ChatResponseChunk {
    @NotNull
    private final String id;
    private final long created;
    @NotNull
    private final List<ChatChoiceChunk> choices;

    public ChatResponseChunk(@NotNull String id, long created, @NotNull List<ChatChoiceChunk> choices) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        this.id = id;
        this.created = created;
        this.choices = choices;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getCreated() {
        return this.created;
    }

    @NotNull
    public final List<ChatChoiceChunk> getChoices() {
        return this.choices;
    }

    /*
     * WARNING - void declaration
     */
    public final void update$ChatGPT_Java_API(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonArray jsonArray = json.get("choices").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"json[\"choices\"].asJsonArray");
        Iterable $this$forEachIndexed$iv = (Iterable)jsonArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void jsonElement;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonElement jsonElement2 = (JsonElement)item$iv;
            int index = n;
            boolean bl = false;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonElement.asJsonObject");
            this.choices.get(index).update$ChatGPT_Java_API(jsonObject);
        }
    }

    @NotNull
    public final Instant getTime() {
        Instant instant = Instant.ofEpochSecond(this.created);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(created)");
        return instant;
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime(@NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.getTime(), timezone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(getTime(), timezone)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getZonedTime$default(ChatResponseChunk chatResponseChunk, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = TimeZone.getDefault().toZoneId();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"getDefault().toZoneId()");
            zoneId = zoneId2;
        }
        return chatResponseChunk.getZonedTime(zoneId);
    }

    @NotNull
    public final ChatChoiceChunk get(int index) {
        return this.choices.get(index);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.created;
    }

    @NotNull
    public final List<ChatChoiceChunk> component3() {
        return this.choices;
    }

    @NotNull
    public final ChatResponseChunk copy(@NotNull String id, long created, @NotNull List<ChatChoiceChunk> choices) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new ChatResponseChunk(id, created, choices);
    }

    public static /* synthetic */ ChatResponseChunk copy$default(ChatResponseChunk chatResponseChunk, String string, long l, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = chatResponseChunk.id;
        }
        if ((n & 2) != 0) {
            l = chatResponseChunk.created;
        }
        if ((n & 4) != 0) {
            list = chatResponseChunk.choices;
        }
        return chatResponseChunk.copy(string, l, list);
    }

    @NotNull
    public String toString() {
        return "ChatResponseChunk(id=" + this.id + ", created=" + this.created + ", choices=" + this.choices + ')';
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + ((Object)this.choices).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatResponseChunk)) {
            return false;
        }
        ChatResponseChunk chatResponseChunk = (ChatResponseChunk)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)chatResponseChunk.id)) {
            return false;
        }
        if (this.created != chatResponseChunk.created) {
            return false;
        }
        return Intrinsics.areEqual(this.choices, chatResponseChunk.choices);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime() {
        return ChatResponseChunk.getZonedTime$default(this, null, 1, null);
    }
}

