/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.chat;

import com.cjcrafter.openai.chat.ChatChoice;
import com.cjcrafter.openai.chat.ChatUsage;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0012\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\t\u0010%\u001a\u00020\u001eH\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/cjcrafter/openai/chat/ChatResponse;", "", "id", "", "created", "", "choices", "", "Lcom/cjcrafter/openai/chat/ChatChoice;", "usage", "Lcom/cjcrafter/openai/chat/ChatUsage;", "(Ljava/lang/String;JLjava/util/List;Lcom/cjcrafter/openai/chat/ChatUsage;)V", "getChoices", "()Ljava/util/List;", "getCreated", "()J", "getId", "()Ljava/lang/String;", "getUsage", "()Lcom/cjcrafter/openai/chat/ChatUsage;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "get", "index", "", "getTime", "Ljava/time/Instant;", "getZonedTime", "Ljava/time/ZonedDateTime;", "timezone", "Ljava/time/ZoneId;", "hashCode", "toString", "ChatGPT-Java-API"})
public final class ChatResponse {
    @NotNull
    private final String id;
    private final long created;
    @NotNull
    private final List<ChatChoice> choices;
    @NotNull
    private final ChatUsage usage;

    public ChatResponse(@NotNull String id, long created, @NotNull List<ChatChoice> choices, @NotNull ChatUsage usage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        this.id = id;
        this.created = created;
        this.choices = choices;
        this.usage = usage;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getCreated() {
        return this.created;
    }

    @NotNull
    public final List<ChatChoice> getChoices() {
        return this.choices;
    }

    @NotNull
    public final ChatUsage getUsage() {
        return this.usage;
    }

    @NotNull
    public final Instant getTime() {
        Instant instant = Instant.ofEpochSecond(this.created);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(created)");
        return instant;
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime(@NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.getTime(), timezone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(getTime(), timezone)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getZonedTime$default(ChatResponse chatResponse, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = TimeZone.getDefault().toZoneId();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"getDefault().toZoneId()");
            zoneId = zoneId2;
        }
        return chatResponse.getZonedTime(zoneId);
    }

    @NotNull
    public final ChatChoice get(int index) {
        return this.choices.get(index);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.created;
    }

    @NotNull
    public final List<ChatChoice> component3() {
        return this.choices;
    }

    @NotNull
    public final ChatUsage component4() {
        return this.usage;
    }

    @NotNull
    public final ChatResponse copy(@NotNull String id, long created, @NotNull List<ChatChoice> choices, @NotNull ChatUsage usage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        return new ChatResponse(id, created, choices, usage);
    }

    public static /* synthetic */ ChatResponse copy$default(ChatResponse chatResponse, String string, long l, List list, ChatUsage chatUsage, int n, Object object) {
        if ((n & 1) != 0) {
            string = chatResponse.id;
        }
        if ((n & 2) != 0) {
            l = chatResponse.created;
        }
        if ((n & 4) != 0) {
            list = chatResponse.choices;
        }
        if ((n & 8) != 0) {
            chatUsage = chatResponse.usage;
        }
        return chatResponse.copy(string, l, list, chatUsage);
    }

    @NotNull
    public String toString() {
        return "ChatResponse(id=" + this.id + ", created=" + this.created + ", choices=" + this.choices + ", usage=" + this.usage + ')';
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + ((Object)this.choices).hashCode();
        result = result * 31 + this.usage.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatResponse)) {
            return false;
        }
        ChatResponse chatResponse = (ChatResponse)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)chatResponse.id)) {
            return false;
        }
        if (this.created != chatResponse.created) {
            return false;
        }
        if (!Intrinsics.areEqual(this.choices, chatResponse.choices)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.usage, (Object)chatResponse.usage);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime getZonedTime() {
        return ChatResponse.getZonedTime$default(this, null, 1, null);
    }
}

