/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.chat;

import com.cjcrafter.openai.FinishReason;
import com.cjcrafter.openai.chat.ChatMessage;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010 \u001a\u00020\u001dJ\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/cjcrafter/openai/chat/ChatChoiceChunk;", "", "index", "", "message", "Lcom/cjcrafter/openai/chat/ChatMessage;", "delta", "", "finishReason", "Lcom/cjcrafter/openai/FinishReason;", "(ILcom/cjcrafter/openai/chat/ChatMessage;Ljava/lang/String;Lcom/cjcrafter/openai/FinishReason;)V", "getDelta", "()Ljava/lang/String;", "setDelta", "(Ljava/lang/String;)V", "getFinishReason", "()Lcom/cjcrafter/openai/FinishReason;", "setFinishReason", "(Lcom/cjcrafter/openai/FinishReason;)V", "getIndex", "()I", "getMessage", "()Lcom/cjcrafter/openai/chat/ChatMessage;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "isFinished", "toString", "update", "", "json", "Lcom/google/gson/JsonObject;", "update$ChatGPT_Java_API", "ChatGPT-Java-API"})
public final class ChatChoiceChunk {
    private final int index;
    @NotNull
    private final ChatMessage message;
    @NotNull
    private String delta;
    @SerializedName(value="finish_reason")
    @Nullable
    private FinishReason finishReason;

    public ChatChoiceChunk(int index, @NotNull ChatMessage message, @NotNull String delta, @Nullable FinishReason finishReason) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        this.index = index;
        this.message = message;
        this.delta = delta;
        this.finishReason = finishReason;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final ChatMessage getMessage() {
        return this.message;
    }

    @NotNull
    public final String getDelta() {
        return this.delta;
    }

    public final void setDelta(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.delta = string;
    }

    @Nullable
    public final FinishReason getFinishReason() {
        return this.finishReason;
    }

    public final void setFinishReason(@Nullable FinishReason finishReason) {
        this.finishReason = finishReason;
    }

    public final void update$ChatGPT_Java_API(@NotNull JsonObject json) {
        FinishReason finishReason;
        String string;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonObject deltaJson = json.get("delta").getAsJsonObject();
        if (deltaJson.has("content")) {
            String string2 = deltaJson.get("content").getAsString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"deltaJson[\"content\"].asString");
        } else {
            string = "";
        }
        this.delta = string;
        ChatMessage chatMessage = this.message;
        chatMessage.setContent(chatMessage.getContent() + this.delta);
        if (json.get("finish_reason").isJsonNull()) {
            finishReason = null;
        } else {
            String string3 = json.get("finish_reason").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json[\"finish_reason\"].asString");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            finishReason = FinishReason.valueOf(string4);
        }
        this.finishReason = finishReason;
    }

    public final boolean isFinished() {
        return this.finishReason != null;
    }

    public final int component1() {
        return this.index;
    }

    @NotNull
    public final ChatMessage component2() {
        return this.message;
    }

    @NotNull
    public final String component3() {
        return this.delta;
    }

    @Nullable
    public final FinishReason component4() {
        return this.finishReason;
    }

    @NotNull
    public final ChatChoiceChunk copy(int index, @NotNull ChatMessage message, @NotNull String delta, @Nullable FinishReason finishReason) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        return new ChatChoiceChunk(index, message, delta, finishReason);
    }

    public static /* synthetic */ ChatChoiceChunk copy$default(ChatChoiceChunk chatChoiceChunk, int n, ChatMessage chatMessage, String string, FinishReason finishReason, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = chatChoiceChunk.index;
        }
        if ((n2 & 2) != 0) {
            chatMessage = chatChoiceChunk.message;
        }
        if ((n2 & 4) != 0) {
            string = chatChoiceChunk.delta;
        }
        if ((n2 & 8) != 0) {
            finishReason = chatChoiceChunk.finishReason;
        }
        return chatChoiceChunk.copy(n, chatMessage, string, finishReason);
    }

    @NotNull
    public String toString() {
        return "ChatChoiceChunk(index=" + this.index + ", message=" + this.message + ", delta=" + this.delta + ", finishReason=" + (Object)((Object)this.finishReason) + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.index);
        result = result * 31 + this.message.hashCode();
        result = result * 31 + this.delta.hashCode();
        result = result * 31 + (this.finishReason == null ? 0 : this.finishReason.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatChoiceChunk)) {
            return false;
        }
        ChatChoiceChunk chatChoiceChunk = (ChatChoiceChunk)other;
        if (this.index != chatChoiceChunk.index) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)chatChoiceChunk.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.delta, (Object)chatChoiceChunk.delta)) {
            return false;
        }
        return this.finishReason == chatChoiceChunk.finishReason;
    }
}

