/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai.chat;

import com.cjcrafter.openai.chat.ChatRequest;
import com.cjcrafter.openai.chat.ChatResponse;
import com.cjcrafter.openai.chat.ChatResponseChunk;
import com.cjcrafter.openai.chat.ChatUser;
import com.cjcrafter.openai.exception.OpenAIError;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use com.cjcrafter.openai.OpenAI", level=DeprecationLevel.ERROR)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0007J'\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u001a\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/cjcrafter/openai/chat/ChatBot;", "", "apiKey", "", "organization", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "gson", "Lcom/google/gson/Gson;", "mediaType", "Lokhttp3/MediaType;", "buildRequest", "Lokhttp3/Request;", "request", "Lcom/cjcrafter/openai/chat/ChatRequest;", "generateResponse", "Lcom/cjcrafter/openai/chat/ChatResponse;", "streamResponse", "", "onResponse", "Ljava/util/function/Consumer;", "Lcom/cjcrafter/openai/chat/ChatResponseChunk;", "onFailure", "Ljava/io/IOException;", "streamResponseKotlin", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ChatGPT-Java-API"})
public final class ChatBot {
    @NotNull
    private final String apiKey;
    @Nullable
    private final String organization;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final MediaType mediaType;
    @NotNull
    private final Gson gson;

    @JvmOverloads
    public ChatBot(@NotNull String apiKey, @Nullable String organization, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.apiKey = apiKey;
        this.organization = organization;
        this.client = client;
        this.mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ChatUser.class), ChatBot::gson$lambda$0).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n        .r\u2026))!! })\n        .create()");
        this.gson = gson;
    }

    public /* synthetic */ ChatBot(String string, String string2, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(string, string2, okHttpClient);
    }

    private final Request buildRequest(ChatRequest request) {
        Request.Builder builder;
        String json = this.gson.toJson((Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        RequestBody body = RequestBody.Companion.create(json, this.mediaType);
        Request.Builder $this$buildRequest_u24lambda_u241 = builder = new Request.Builder().url("https://api.openai.com/v1/chat/completions").addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.apiKey);
        boolean bl = false;
        if (this.organization != null) {
            $this$buildRequest_u24lambda_u241.addHeader("OpenAI-Organization", this.organization);
        }
        return builder.post(body).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ChatResponse generateResponse(@NotNull ChatRequest request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.setStream(false);
        Request httpRequest = this.buildRequest(request);
        JsonObject rootObject = null;
        try {
            Closeable closeable = (Closeable)this.client.newCall(httpRequest).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                JsonObject jsonObject = rootObject = JsonParser.parseString((String)responseBody.string()).getAsJsonObject();
                Intrinsics.checkNotNull((Object)jsonObject);
                if (jsonObject.has("error")) {
                    JsonObject jsonObject2 = rootObject.get("error").getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"rootObject!![\"error\"].asJsonObject");
                    throw OpenAIError.Companion.fromJson(jsonObject2);
                }
                Object object = this.gson.fromJson((JsonElement)rootObject, ChatResponse.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(rootObject\u2026ChatResponse::class.java)");
                ChatResponse chatResponse = (ChatResponse)object;
                return chatResponse;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            System.out.println(rootObject);
            throw ex;
        }
    }

    public final void streamResponseKotlin(@NotNull ChatRequest request, @NotNull Function1<? super ChatResponseChunk, Unit> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        ChatBot.streamResponse$default(this, request, arg_0 -> ChatBot.streamResponseKotlin$lambda$3(onResponse, arg_0), null, 4, null);
    }

    @JvmOverloads
    public final void streamResponse(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse, @NotNull Consumer<IOException> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(true);
        Request httpRequest = this.buildRequest(request);
        this.client.newCall(httpRequest).enqueue(new Callback(onFailure, this, onResponse){
            @Nullable
            private ChatResponseChunk cache;
            final /* synthetic */ Consumer<IOException> $onFailure;
            final /* synthetic */ ChatBot this$0;
            final /* synthetic */ Consumer<ChatResponseChunk> $onResponse;
            {
                this.$onFailure = $onFailure;
                this.this$0 = $receiver;
                this.$onResponse = $onResponse;
            }

            @Nullable
            public final ChatResponseChunk getCache() {
                return this.cache;
            }

            public final void setCache(@Nullable ChatResponseChunk chatResponseChunk) {
                this.cache = chatResponseChunk;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$onFailure.accept(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                if (responseBody != null && (responseBody = responseBody.source()) != null) {
                    Closeable closeable = (Closeable)responseBody;
                    ChatBot chatBot = this.this$0;
                    Consumer<ChatResponseChunk> consumer = this.$onResponse;
                    Throwable throwable = null;
                    try {
                        BufferedSource source = (BufferedSource)closeable;
                        boolean bl = false;
                        while (!source.exhausted()) {
                            String jsonResponse;
                            if (source.readUtf8Line() == null || ((CharSequence)jsonResponse).length() == 0) continue;
                            String string = jsonResponse.substring(6);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            jsonResponse = string;
                            if (Intrinsics.areEqual((Object)jsonResponse, (Object)"[DONE]")) continue;
                            JsonObject rootObject = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
                            if (this.cache == null) {
                                this.cache = (ChatResponseChunk)ChatBot.access$getGson$p(chatBot).fromJson((JsonElement)rootObject, ChatResponseChunk.class);
                            } else {
                                ChatResponseChunk chatResponseChunk = this.cache;
                                Intrinsics.checkNotNull((Object)chatResponseChunk);
                                Intrinsics.checkNotNullExpressionValue((Object)rootObject, (String)"rootObject");
                                chatResponseChunk.update$ChatGPT_Java_API(rootObject);
                            }
                            ChatResponseChunk chatResponseChunk = this.cache;
                            Intrinsics.checkNotNull((Object)chatResponseChunk);
                            consumer.accept(chatResponseChunk);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        });
    }

    public static /* synthetic */ void streamResponse$default(ChatBot chatBot, ChatRequest chatRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = ChatBot::streamResponse$lambda$4;
        }
        chatBot.streamResponse(chatRequest, consumer, consumer2);
    }

    @JvmOverloads
    public ChatBot(@NotNull String apiKey, @Nullable String organization) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this(apiKey, organization, null, 4, null);
    }

    @JvmOverloads
    public ChatBot(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this(apiKey, null, null, 6, null);
    }

    @JvmOverloads
    public final void streamResponse(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        ChatBot.streamResponse$default(this, request, onResponse, null, 4, null);
    }

    private static final JsonElement gson$lambda$0(ChatUser src, Type type, JsonSerializationContext context) {
        JsonSerializationContext jsonSerializationContext = context;
        Intrinsics.checkNotNull((Object)jsonSerializationContext);
        ChatUser chatUser = src;
        Intrinsics.checkNotNull((Object)((Object)chatUser));
        String string = chatUser.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        JsonElement jsonElement = jsonSerializationContext.serialize((Object)string);
        Intrinsics.checkNotNull((Object)jsonElement);
        return jsonElement;
    }

    private static final void streamResponseKotlin$lambda$3(Function1 $onResponse, ChatResponseChunk it) {
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $onResponse.invoke((Object)it);
    }

    private static final void streamResponse$lambda$4(IOException it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    public static final /* synthetic */ Gson access$getGson$p(ChatBot $this) {
        return $this.gson;
    }
}

