/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai;

import com.cjcrafter.openai.exception.OpenAIError;
import com.cjcrafter.openai.exception.WrappedIOError;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/cjcrafter/openai/OpenAICallback;", "Lokhttp3/Callback;", "isStream", "", "onFailure", "Ljava/util/function/Consumer;", "Lcom/cjcrafter/openai/exception/OpenAIError;", "onResponse", "Lcom/google/gson/JsonObject;", "(ZLjava/util/function/Consumer;Ljava/util/function/Consumer;)V", "handleStream", "", "response", "Lokhttp3/Response;", "call", "Lokhttp3/Call;", "e", "Ljava/io/IOException;", "ChatGPT-Java-API"})
public final class OpenAICallback
implements Callback {
    private final boolean isStream;
    @NotNull
    private final Consumer<OpenAIError> onFailure;
    @NotNull
    private final Consumer<JsonObject> onResponse;

    public OpenAICallback(boolean isStream, @NotNull Consumer<OpenAIError> onFailure, @NotNull Consumer<JsonObject> onResponse) {
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        this.isStream = isStream;
        this.onFailure = onFailure;
        this.onResponse = onResponse;
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.onFailure.accept(new WrappedIOError(e));
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.onResponse(response);
    }

    public final void onResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this.isStream) {
            this.handleStream(response);
            return;
        }
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        JsonObject rootObject = JsonParser.parseString((String)responseBody.string()).getAsJsonObject();
        if (rootObject.has("error")) {
            JsonObject jsonObject = rootObject.get("error").getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"rootObject.get(\"error\").asJsonObject");
            this.onFailure.accept(OpenAIError.Companion.fromJson(jsonObject));
            return;
        }
        this.onResponse.accept(rootObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleStream(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody != null && (responseBody = responseBody.source()) != null) {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                BufferedSource source = (BufferedSource)closeable;
                boolean bl = false;
                while (!source.exhausted()) {
                    String jsonResponse = source.readUtf8Line();
                    CharSequence charSequence = jsonResponse;
                    if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)jsonResponse, (Object)"data: [DONE]")) continue;
                    if (StringsKt.startsWith$default((String)jsonResponse, (String)"data: ", (boolean)false, (int)2, null)) {
                        String string = jsonResponse.substring(6);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        jsonResponse = string;
                    }
                    JsonObject rootObject = null;
                    try {
                        JsonObject jsonObject = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"parseString(jsonResponse).asJsonObject");
                        rootObject = jsonObject;
                    }
                    catch (JsonParseException ex) {
                        System.out.println((Object)jsonResponse);
                        ex.printStackTrace();
                        continue;
                    }
                    JsonObject jsonObject = rootObject;
                    if (jsonObject == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"rootObject");
                        jsonObject = null;
                    }
                    if (jsonObject.has("error")) {
                        JsonObject jsonObject2 = rootObject.get("error").getAsJsonObject();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"rootObject.get(\"error\").asJsonObject");
                        this.onFailure.accept(OpenAIError.Companion.fromJson(jsonObject2));
                        continue;
                    }
                    this.onResponse.accept(rootObject);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

