/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.openai;

import com.cjcrafter.openai.FinishReason;
import com.cjcrafter.openai.OpenAICallback;
import com.cjcrafter.openai.chat.ChatChoiceChunk;
import com.cjcrafter.openai.chat.ChatRequest;
import com.cjcrafter.openai.chat.ChatResponse;
import com.cjcrafter.openai.chat.ChatResponseChunk;
import com.cjcrafter.openai.chat.ChatUser;
import com.cjcrafter.openai.completions.CompletionRequest;
import com.cjcrafter.openai.completions.CompletionResponse;
import com.cjcrafter.openai.completions.CompletionResponseChunk;
import com.cjcrafter.openai.exception.OpenAIError;
import com.cjcrafter.openai.exception.WrappedIOError;
import com.cjcrafter.openai.gson.ChatChoiceChunkAdapter;
import com.cjcrafter.openai.gson.ChatUserAdapter;
import com.cjcrafter.openai.gson.FinishReasonAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001bJ.\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J.\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J.\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J.\u0010 \u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J.\u0010\"\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/cjcrafter/openai/OpenAI;", "", "apiKey", "", "organization", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "gson", "Lcom/google/gson/Gson;", "mediaType", "Lokhttp3/MediaType;", "buildRequest", "Lokhttp3/Request;", "request", "endpoint", "createChatCompletion", "Lcom/cjcrafter/openai/chat/ChatResponse;", "Lcom/cjcrafter/openai/chat/ChatRequest;", "createChatCompletionAsync", "", "onResponse", "Ljava/util/function/Consumer;", "onFailure", "Lcom/cjcrafter/openai/exception/OpenAIError;", "createCompletion", "Lcom/cjcrafter/openai/completions/CompletionResponse;", "Lcom/cjcrafter/openai/completions/CompletionRequest;", "createCompletionAsync", "streamChatCompletion", "Lcom/cjcrafter/openai/chat/ChatResponseChunk;", "streamChatCompletionAsync", "streamCompletion", "Lcom/cjcrafter/openai/completions/CompletionResponseChunk;", "streamCompletionAsync", "Companion", "ChatGPT-Java-API"})
public final class OpenAI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiKey;
    @Nullable
    private final String organization;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final MediaType mediaType;
    @NotNull
    private final Gson gson;
    @NotNull
    public static final String COMPLETIONS_ENDPOINT = "completions";
    @NotNull
    public static final String CHAT_ENDPOINT = "chat/completions";

    @JvmOverloads
    public OpenAI(@NotNull String apiKey, @Nullable String organization, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.apiKey = apiKey;
        this.organization = organization;
        this.client = client;
        this.mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        this.gson = Companion.createGson();
    }

    public /* synthetic */ OpenAI(String string, String string2, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(string, string2, okHttpClient);
    }

    private final Request buildRequest(Object request, String endpoint) {
        Request.Builder builder;
        String json = this.gson.toJson(request);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        RequestBody body = RequestBody.Companion.create(json, this.mediaType);
        Request.Builder $this$buildRequest_u24lambda_u240 = builder = new Request.Builder().url("https://api.openai.com/v1/" + endpoint).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.apiKey);
        boolean bl = false;
        if (this.organization != null) {
            $this$buildRequest_u24lambda_u240.addHeader("OpenAI-Organization", this.organization);
        }
        return builder.post(body).build();
    }

    @NotNull
    public final CompletionResponse createCompletion(@NotNull CompletionRequest request) throws OpenAIError {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.setStream(false);
        Request httpRequest = this.buildRequest(request, COMPLETIONS_ENDPOINT);
        try {
            CompletionResponse completionResponse;
            Response httpResponse = this.client.newCall(httpRequest).execute();
            Ref.ObjectRef response = new Ref.ObjectRef();
            new OpenAICallback(true, OpenAI::createCompletion$lambda$1, arg_0 -> OpenAI.createCompletion$lambda$2(response, this, arg_0)).onResponse(httpResponse);
            if (response.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                completionResponse = null;
            } else {
                completionResponse = (CompletionResponse)response.element;
            }
            return completionResponse;
        }
        catch (IOException ex) {
            throw new WrappedIOError(ex);
        }
    }

    @JvmOverloads
    public final void createCompletionAsync(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponse> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(false);
        Request httpRequest = this.buildRequest(request, COMPLETIONS_ENDPOINT);
        this.client.newCall(httpRequest).enqueue((Callback)new OpenAICallback(false, onFailure, arg_0 -> OpenAI.createCompletionAsync$lambda$4(this, onResponse, arg_0)));
    }

    public static /* synthetic */ void createCompletionAsync$default(OpenAI openAI, CompletionRequest completionRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::createCompletionAsync$lambda$3;
        }
        openAI.createCompletionAsync(completionRequest, consumer, consumer2);
    }

    @JvmOverloads
    public final void streamCompletion(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponseChunk> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(true);
        Request httpRequest = this.buildRequest(request, COMPLETIONS_ENDPOINT);
        try {
            Response httpResponse = this.client.newCall(httpRequest).execute();
            new OpenAICallback(true, onFailure, arg_0 -> OpenAI.streamCompletion$lambda$6(this, onResponse, arg_0)).onResponse(httpResponse);
        }
        catch (IOException ex) {
            onFailure.accept(new WrappedIOError(ex));
        }
    }

    public static /* synthetic */ void streamCompletion$default(OpenAI openAI, CompletionRequest completionRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::streamCompletion$lambda$5;
        }
        openAI.streamCompletion(completionRequest, consumer, consumer2);
    }

    @JvmOverloads
    public final void streamCompletionAsync(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponseChunk> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(true);
        Request httpRequest = this.buildRequest(request, COMPLETIONS_ENDPOINT);
        this.client.newCall(httpRequest).enqueue((Callback)new OpenAICallback(true, onFailure, arg_0 -> OpenAI.streamCompletionAsync$lambda$8(this, onResponse, arg_0)));
    }

    public static /* synthetic */ void streamCompletionAsync$default(OpenAI openAI, CompletionRequest completionRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::streamCompletionAsync$lambda$7;
        }
        openAI.streamCompletionAsync(completionRequest, consumer, consumer2);
    }

    @NotNull
    public final ChatResponse createChatCompletion(@NotNull ChatRequest request) throws OpenAIError {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.setStream(false);
        Request httpRequest = this.buildRequest(request, CHAT_ENDPOINT);
        try {
            ChatResponse chatResponse;
            Response httpResponse = this.client.newCall(httpRequest).execute();
            Ref.ObjectRef response = new Ref.ObjectRef();
            new OpenAICallback(true, OpenAI::createChatCompletion$lambda$9, arg_0 -> OpenAI.createChatCompletion$lambda$10(response, this, arg_0)).onResponse(httpResponse);
            if (response.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                chatResponse = null;
            } else {
                chatResponse = (ChatResponse)response.element;
            }
            return chatResponse;
        }
        catch (IOException ex) {
            throw new WrappedIOError(ex);
        }
    }

    @JvmOverloads
    public final void createChatCompletionAsync(@NotNull ChatRequest request, @NotNull Consumer<ChatResponse> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(false);
        Request httpRequest = this.buildRequest(request, CHAT_ENDPOINT);
        this.client.newCall(httpRequest).enqueue((Callback)new OpenAICallback(false, onFailure, arg_0 -> OpenAI.createChatCompletionAsync$lambda$12(this, onResponse, arg_0)));
    }

    public static /* synthetic */ void createChatCompletionAsync$default(OpenAI openAI, ChatRequest chatRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::createChatCompletionAsync$lambda$11;
        }
        openAI.createChatCompletionAsync(chatRequest, consumer, consumer2);
    }

    @JvmOverloads
    public final void streamChatCompletion(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(true);
        Request httpRequest = this.buildRequest(request, CHAT_ENDPOINT);
        try {
            Response httpResponse = this.client.newCall(httpRequest).execute();
            Ref.ObjectRef response = new Ref.ObjectRef();
            new OpenAICallback(true, onFailure, arg_0 -> OpenAI.streamChatCompletion$lambda$14(response, this, onResponse, arg_0)).onResponse(httpResponse);
        }
        catch (IOException ex) {
            onFailure.accept(new WrappedIOError(ex));
        }
    }

    public static /* synthetic */ void streamChatCompletion$default(OpenAI openAI, ChatRequest chatRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::streamChatCompletion$lambda$13;
        }
        openAI.streamChatCompletion(chatRequest, consumer, consumer2);
    }

    @JvmOverloads
    public final void streamChatCompletionAsync(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse, @NotNull Consumer<OpenAIError> onFailure) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.setStream(true);
        Request httpRequest = this.buildRequest(request, CHAT_ENDPOINT);
        Ref.ObjectRef response = new Ref.ObjectRef();
        this.client.newCall(httpRequest).enqueue((Callback)new OpenAICallback(true, onFailure, arg_0 -> OpenAI.streamChatCompletionAsync$lambda$16(response, this, onResponse, arg_0)));
    }

    public static /* synthetic */ void streamChatCompletionAsync$default(OpenAI openAI, ChatRequest chatRequest, Consumer consumer, Consumer consumer2, int n, Object object) {
        if ((n & 4) != 0) {
            consumer2 = OpenAI::streamChatCompletionAsync$lambda$15;
        }
        openAI.streamChatCompletionAsync(chatRequest, consumer, consumer2);
    }

    @JvmOverloads
    public OpenAI(@NotNull String apiKey, @Nullable String organization) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this(apiKey, organization, null, 4, null);
    }

    @JvmOverloads
    public OpenAI(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this(apiKey, null, null, 6, null);
    }

    @JvmOverloads
    public final void createCompletionAsync(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponse> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.createCompletionAsync$default(this, request, onResponse, null, 4, null);
    }

    @JvmOverloads
    public final void streamCompletion(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponseChunk> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.streamCompletion$default(this, request, onResponse, null, 4, null);
    }

    @JvmOverloads
    public final void streamCompletionAsync(@NotNull CompletionRequest request, @NotNull Consumer<CompletionResponseChunk> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.streamCompletionAsync$default(this, request, onResponse, null, 4, null);
    }

    @JvmOverloads
    public final void createChatCompletionAsync(@NotNull ChatRequest request, @NotNull Consumer<ChatResponse> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.createChatCompletionAsync$default(this, request, onResponse, null, 4, null);
    }

    @JvmOverloads
    public final void streamChatCompletion(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.streamChatCompletion$default(this, request, onResponse, null, 4, null);
    }

    @JvmOverloads
    public final void streamChatCompletionAsync(@NotNull ChatRequest request, @NotNull Consumer<ChatResponseChunk> onResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onResponse, (String)"onResponse");
        OpenAI.streamChatCompletionAsync$default(this, request, onResponse, null, 4, null);
    }

    private static final void createCompletion$lambda$1(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        throw it;
    }

    private static final void createCompletion$lambda$2(Ref.ObjectRef $response, OpenAI this$0, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.gson.fromJson((JsonElement)it, CompletionResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(it, CompletionResponse::class.java)");
        $response.element = object;
    }

    private static final void createCompletionAsync$lambda$3(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void createCompletionAsync$lambda$4(OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletionResponse response = (CompletionResponse)this$0.gson.fromJson((JsonElement)it, CompletionResponse.class);
        $onResponse.accept(response);
    }

    private static final void streamCompletion$lambda$5(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void streamCompletion$lambda$6(OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletionResponseChunk response = (CompletionResponseChunk)this$0.gson.fromJson((JsonElement)it, CompletionResponseChunk.class);
        $onResponse.accept(response);
    }

    private static final void streamCompletionAsync$lambda$7(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void streamCompletionAsync$lambda$8(OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletionResponseChunk response = (CompletionResponseChunk)this$0.gson.fromJson((JsonElement)it, CompletionResponseChunk.class);
        $onResponse.accept(response);
    }

    private static final void createChatCompletion$lambda$9(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        throw it;
    }

    private static final void createChatCompletion$lambda$10(Ref.ObjectRef $response, OpenAI this$0, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.gson.fromJson((JsonElement)it, ChatResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(it, ChatResponse::class.java)");
        $response.element = object;
    }

    private static final void createChatCompletionAsync$lambda$11(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void createChatCompletionAsync$lambda$12(OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChatResponse response = (ChatResponse)this$0.gson.fromJson((JsonElement)it, ChatResponse.class);
        $onResponse.accept(response);
    }

    private static final void streamChatCompletion$lambda$13(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void streamChatCompletion$lambda$14(Ref.ObjectRef $response, OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($response.element == null) {
            $response.element = this$0.gson.fromJson((JsonElement)it, ChatResponseChunk.class);
        } else {
            Object object = $response.element;
            Intrinsics.checkNotNull((Object)object);
            ((ChatResponseChunk)object).update$ChatGPT_Java_API(it);
        }
        Object object = $response.element;
        Intrinsics.checkNotNull((Object)object);
        $onResponse.accept(object);
    }

    private static final void streamChatCompletionAsync$lambda$15(OpenAIError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printStackTrace();
    }

    private static final void streamChatCompletionAsync$lambda$16(Ref.ObjectRef $response, OpenAI this$0, Consumer $onResponse, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onResponse, (String)"$onResponse");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($response.element == null) {
            $response.element = this$0.gson.fromJson((JsonElement)it, ChatResponseChunk.class);
        } else {
            Object object = $response.element;
            Intrinsics.checkNotNull((Object)object);
            ((ChatResponseChunk)object).update$ChatGPT_Java_API(it);
        }
        Object object = $response.element;
        Intrinsics.checkNotNull((Object)object);
        $onResponse.accept(object);
    }

    @JvmStatic
    @NotNull
    public static final Gson createGson() {
        return Companion.createGson();
    }

    @JvmStatic
    @NotNull
    public static final GsonBuilder createGsonBuilder() {
        return Companion.createGsonBuilder();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/cjcrafter/openai/OpenAI$Companion;", "", "()V", "CHAT_ENDPOINT", "", "COMPLETIONS_ENDPOINT", "createGson", "Lcom/google/gson/Gson;", "createGsonBuilder", "Lcom/google/gson/GsonBuilder;", "ChatGPT-Java-API"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Gson createGson() {
            Gson gson = this.createGsonBuilder().create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"createGsonBuilder().create()");
            return gson;
        }

        @JvmStatic
        @NotNull
        public final GsonBuilder createGsonBuilder() {
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter((Type)((Object)ChatUser.class), (Object)new ChatUserAdapter()).registerTypeAdapter((Type)((Object)FinishReason.class), (Object)new FinishReasonAdapter()).registerTypeAdapter((Type)((Object)ChatChoiceChunk.class), (Object)new ChatChoiceChunkAdapter());
            Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder, (String)"GsonBuilder()\n          \u2026ChatChoiceChunkAdapter())");
            return gsonBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

