/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils.primitive;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Consumer;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.primitive.BiDoubleConsumer;
import me.deecaad.core.utils.primitive.DoubleCollection;
import me.deecaad.core.utils.primitive.DoubleEntry;

public class DoubleMap<K> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Node<K>[] table;
    private final float loadFactor;
    private int threshold;
    private int size;
    private Set<DoubleEntry<K>> entrySet;
    private Set<K> keySet;
    private DoubleCollection values;

    public DoubleMap() {
        this.loadFactor = 0.75f;
    }

    public DoubleMap(int cap) {
        this();
        this.threshold = cap;
    }

    private int hash(Object key) {
        return key.hashCode();
    }

    private Node<K> getNode(Object key) {
        if (this.table == null) {
            return null;
        }
        Node<K> node = this.table[this.hash(key) & this.table.length - 1];
        if (node != null) {
            do {
                if (!Objects.equals(node.key, key)) continue;
                return node;
            } while ((node = node.next) != null);
        }
        return null;
    }

    private void resize() {
        int newCap;
        Node<K>[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node<K> node = oldTab[j];
                if (node == null) continue;
                oldTab[j] = null;
                if (node.next == null) {
                    newTab[node.hash & newCap - 1] = node;
                    continue;
                }
                Node<K> loHead = null;
                Node<K> loTail = null;
                Node<K> hiHead = null;
                Node<K> hiTail = null;
                do {
                    next = node.next;
                    if ((node.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = node;
                        } else {
                            loTail.next = node;
                        }
                        loTail = node;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = node;
                    } else {
                        hiTail.next = node;
                    }
                    hiTail = node;
                } while ((node = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        return this.getNode(key) != null;
    }

    public boolean containsValue(double value) {
        ValueIterator iterator = new ValueIterator();
        while (iterator.hasNext()) {
            if (!NumberUtil.approximately(value, iterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    public double get(Object key) {
        Node<K> node = this.getNode(key);
        return node == null ? 0.0 : node.value;
    }

    public double put(K key, double value) {
        int hash;
        int index;
        Node<K> node;
        if (this.table == null) {
            this.resize();
        }
        if ((node = this.table[index = (hash = this.hash(key)) & this.table.length - 1]) == null) {
            this.table[index] = new Node<K>(key, value, hash);
        } else {
            Node temp;
            if (node.hash == hash && Objects.equals(key, node.hash)) {
                temp = node;
            } else {
                while (true) {
                    if ((temp = node.next) == null) {
                        node.next = new Node<K>(key, value, hash);
                        break;
                    }
                    if (temp.hash == hash && Objects.equals(key, temp.key)) break;
                    node = temp;
                }
            }
            if (temp != null) {
                double old = temp.value;
                temp.value = value;
                return old;
            }
        }
        if (++this.size > this.threshold) {
            this.resize();
        }
        return 0.0;
    }

    public double remove(Object key) {
        Node<K> node = this.removeNode(key);
        return node == null ? 0.0 : node.getValue();
    }

    private Node<K> removeNode(Object key) {
        int hash = this.hash(key);
        int index = hash & this.table.length - 1;
        Node<K> node = this.table[index];
        if (hash == node.hash && Objects.equals(key, node.key)) {
            this.table[index] = node.next;
            return node;
        }
        Node temp;
        while ((temp = node.next) != null) {
            if (hash == temp.hash && Objects.equals(key, temp.key)) {
                return temp;
            }
            node = temp;
        }
        return null;
    }

    public void clear() {
        if (this.table != null && this.size > 0) {
            this.size = 0;
            Arrays.fill(this.table, null);
        }
    }

    public void forEach(BiDoubleConsumer<K> consumer) {
        EntryIterator iterator = new EntryIterator();
        while (iterator.hasNext()) {
            Object entry = iterator.next();
            consumer.accept(((DoubleEntry)entry).getKey(), ((DoubleEntry)entry).getValue());
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public Set<DoubleEntry<K>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoubleMap)) {
            return false;
        }
        DoubleMap map = (DoubleMap)other;
        if (this.size() != map.size()) {
            return false;
        }
        EntryIterator iterator = new EntryIterator();
        while (iterator.hasNext()) {
            Object entry = iterator.next();
            if (((DoubleEntry)entry).equals(map.getNode(((DoubleEntry)entry).getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        EntryIterator iterator = new EntryIterator();
        while (iterator.hasNext()) {
            hash += ((DoubleEntry)iterator.next()).hashCode();
        }
        return hash;
    }

    public String toString() {
        EntryIterator iterator = new EntryIterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        while (true) {
            Object entry = iterator.next();
            Object key = ((DoubleEntry)entry).getKey();
            double value = ((DoubleEntry)entry).getValue();
            builder.append((Object)(key == this ? "(this Map)" : key));
            builder.append('=');
            builder.append(value);
            if (!iterator.hasNext()) {
                return builder.append('}').toString();
            }
            builder.append(',').append(' ');
        }
    }

    private static class Node<K>
    extends DoubleEntry<K> {
        K key;
        double value;
        int hash;
        Node<K> next;

        public Node(K key, double value, int hash) {
            this.key = key;
            this.value = value;
            this.hash = hash;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            double old = this.value;
            this.value = value;
            return old;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements PrimitiveIterator.OfDouble {
        ValueIterator() {
        }

        @Override
        public double nextDouble() {
            return this.nextNode().getValue();
        }

        @Override
        public Double next() {
            return this.nextNode().getValue();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<DoubleEntry<K>> {
        EntryIterator() {
        }

        @Override
        public DoubleEntry<K> next() {
            return new DoubleEntry<K>(){
                private final Node<K> node;
                {
                    this.node = EntryIterator.this.nextNode();
                }

                @Override
                public K getKey() {
                    return this.node.getKey();
                }

                @Override
                public double getValue() {
                    return this.node.getValue();
                }

                @Override
                public double setValue(double value) {
                    return this.node.setValue(value);
                }
            };
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return DoubleMap.this.size;
        }

        @Override
        public void clear() {
            DoubleMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return DoubleMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return DoubleMap.this.removeNode(o) != null;
        }
    }

    private class Values
    implements DoubleCollection {
        private Values() {
        }

        @Override
        public int size() {
            return DoubleMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return DoubleMap.this.isEmpty();
        }

        @Override
        public boolean contains(double num) {
            return DoubleMap.this.containsValue(num);
        }

        @Override
        public boolean add(double num) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            DoubleMap.this.clear();
        }

        @Override
        public PrimitiveIterator.OfDouble iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean remove(double num) {
            PrimitiveIterator.OfDouble iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!NumberUtil.approximately(num, iterator.nextDouble())) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    }

    private class EntrySet
    extends AbstractSet<DoubleEntry<K>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return DoubleMap.this.size;
        }

        @Override
        public void clear() {
            DoubleMap.this.clear();
        }

        @Override
        public Iterator<DoubleEntry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object other) {
            if (!(other instanceof DoubleEntry)) {
                return false;
            }
            DoubleEntry entry = (DoubleEntry)other;
            Node candidate = DoubleMap.this.getNode(entry.getKey());
            return candidate != null && candidate.equals(entry);
        }

        @Override
        public boolean remove(Object other) {
            if (!(other instanceof DoubleEntry)) {
                return false;
            }
            DoubleEntry entry = (DoubleEntry)other;
            return this.remove(entry.getKey());
        }

        @Override
        public void forEach(Consumer<? super DoubleEntry<K>> action) {
            EntryIterator iterator = new EntryIterator();
            while (iterator.hasNext()) {
                Node entry = iterator.next;
                action.accept(entry);
            }
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextNode().getKey();
        }
    }

    private abstract class HashIterator {
        Node<K> next = null;
        Node<K> current = null;
        int index = 0;

        HashIterator() {
            if (DoubleMap.this.table != null && DoubleMap.this.size > 0) {
                while (this.index < DoubleMap.this.table.length && (this.next = DoubleMap.this.table[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K> nextNode() {
            Node node = this.next;
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.current = node;
            this.next = this.current.next;
            if (this.next == null && DoubleMap.this.table != null) {
                while (this.index < DoubleMap.this.table.length && (this.next = DoubleMap.this.table[this.index++]) == null) {
                }
            }
            return node;
        }

        public final void remove() {
            DoubleMap.this.remove(this.current.getKey());
            this.current = null;
        }
    }
}

