/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.utils.Quaternion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class Transform {
    private Vector localPosition;
    private Quaternion localRotation;
    private Transform parent;
    private final List<Transform> children = new ArrayList<Transform>();

    public Transform() {
        this.localRotation = Quaternion.identity();
        this.localPosition = new Vector();
    }

    public Transform(Transform parent) {
        this();
        this.setParent(parent);
    }

    public Transform getParent() {
        return this.parent;
    }

    public Transform getChild(int i) {
        return this.children.get(i);
    }

    public void setParent(Transform parent) {
        if (this.parent != null) {
            this.localPosition = this.getPosition();
            this.localRotation = this.getRotation();
            this.parent.children.remove(this);
        }
        if (parent != null) {
            Quaternion parentRotation = parent.getRotation();
            this.localRotation = parentRotation.inverse().multiply(this.localRotation);
            Vector position = parent.getPosition();
            this.localPosition.subtract(position);
            parent.children.add(this);
        }
        this.parent = parent;
    }

    public Vector getForward() {
        return this.getRotation().multiply(Quaternion.FORWARD);
    }

    public void setForward(Vector forward) {
        this.setRotation(Quaternion.lookAt(forward, Quaternion.UP));
    }

    public Vector getRight() {
        return this.getRotation().multiply(Quaternion.RIGHT);
    }

    public void setRight(Vector right) {
        this.setRotation(Quaternion.fromTo(Quaternion.RIGHT, right));
    }

    public Vector getUp() {
        return this.getRotation().multiply(Quaternion.UP);
    }

    public void setUp(Vector up) {
        this.setRotation(Quaternion.fromTo(Quaternion.UP, up));
    }

    public Vector getLocalPosition() {
        return this.localPosition.clone();
    }

    public void setLocalPosition(Vector localPosition) {
        this.localPosition = localPosition;
    }

    public Vector getPosition() {
        if (this.getParent() == null) {
            return this.getLocalPosition();
        }
        return this.getParent().getPosition().add(this.getParent().getRotation().multiply(this.localPosition));
    }

    public void setPosition(Location position) {
        this.setPosition(position.toVector());
    }

    public void setPosition(Vector position) {
        if (this.getParent() == null) {
            this.setLocalPosition(position);
        } else {
            Vector parentPos = this.getParent().getPosition();
            Quaternion parentRot = this.getParent().getRotation();
            this.setLocalPosition(parentRot.multiply(position.subtract(parentPos)));
        }
    }

    public Quaternion getLocalRotation() {
        return this.localRotation.clone();
    }

    public void setLocalRotation(Quaternion localRotation) {
        this.localRotation = localRotation.normalize();
    }

    public Quaternion getRotation() {
        if (this.getParent() == null) {
            return this.getLocalRotation();
        }
        return this.getParent().getRotation().multiply(this.localRotation);
    }

    public void setRotation(Quaternion rotation) {
        if (this.getParent() == null) {
            this.setLocalRotation(rotation.normalize());
        } else {
            this.setLocalRotation(this.getParent().getRotation().inverse().multiply(rotation));
        }
    }

    public void applyRotation(Quaternion rotation) {
        this.localRotation.multiply(rotation.normalize());
    }

    public void debug(World world) {
        Vector origin = this.getPosition();
    }
}

