/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public final class ReflectionUtil {
    private static final String versionString;
    private static final String nmsVersion;
    private static final String cbVersion;
    private static final Field modifiersField;
    private static final int javaVersion;
    private static final String ERR = "This is probably caused by your minecraft server version. Contact a DEV for more help.";

    private ReflectionUtil() {
    }

    public static int getJavaVersion() {
        return javaVersion;
    }

    public static Class<?> getNMSClass(@NotNull String pack, @NotNull String name) {
        Object className;
        if (MinecraftVersions.CAVES_AND_CLIFFS_2.isAtLeast()) {
            className = "net.minecraft." + pack + "." + name;
            if (CompatibilityAPI.isPaper() && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
                ReflectionRemapper remapper = ReflectionRemapper.forReobfMappingsInPaperJar();
                className = remapper.remapClassOrArrayName((String)className);
            }
        } else {
            className = nmsVersion + name;
        }
        try {
            return Class.forName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to get NMS class " + (String)className + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static Class<?> getPacketClass(@NotNull String className) {
        return ReflectionUtil.getNMSClass("network.protocol.game", className);
    }

    @NotNull
    public static Class<?> getCBClass(@NotNull String className) {
        try {
            return Class.forName(cbVersion + className);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to get CB class " + className + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static <T> Constructor<T> getConstructor(@NotNull Class<T> clazz, Class<?> ... parameters) {
        try {
            return clazz.getConstructor(parameters);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalError("Failed to get constructor. This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> constructorSupplier, Object ... parameters) {
        Class[] classes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            classes[i] = parameters[i].getClass();
            classes[i] = switch (parameters[i].getClass().getSimpleName()) {
                case "Double" -> Double.TYPE;
                case "Integer" -> Integer.TYPE;
                case "Float" -> Float.TYPE;
                case "Boolean" -> Boolean.TYPE;
                case "Byte" -> Byte.TYPE;
                case "Short" -> Short.TYPE;
                case "Long" -> Long.TYPE;
                default -> classes[i];
            };
        }
        try {
            return ReflectionUtil.newInstance(constructorSupplier.getConstructor(classes), parameters);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Failed to instantiate class " + String.valueOf(constructorSupplier) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new InternalError("Failed to instantiate class " + String.valueOf(constructor) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static <T> Class<T> getClass(@NotNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to find class with name " + className + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalError("Failed to instantiate class " + String.valueOf(clazz) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    @NotNull
    public static Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new InternalError("Failed to get field " + fieldName + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    public static Field getField(@NotNull Class<?> target, Class<?> type) {
        return ReflectionUtil.getField(target, type, 0, false);
    }

    public static Field getField(@NotNull Class<?> target, Class<?> type, int index) {
        return ReflectionUtil.getField(target, type, index, false);
    }

    public static Field getField(@NotNull Class<?> target, Class<?> type, int index, boolean skipStatic) {
        for (Field field : target.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType()) || skipStatic && Modifier.isStatic(field.getModifiers()) || index-- > 0) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        Class<?> superClass = target.getSuperclass();
        if (superClass != null) {
            return ReflectionUtil.getField(superClass, type, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + String.valueOf(type));
    }

    public static Object invokeField(@NotNull Field field, @Nullable Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InternalError("Failed to invoke field " + String.valueOf(field) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    public static void setField(@NotNull Field field, @Nullable Object instance, Object value) {
        try {
            if (Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && javaVersion < 12) {
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InternalError("Failed to set field " + String.valueOf(field) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameters) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameters);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalError("Failed to find  method " + methodName + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    public static Method getMethod(@NotNull Class<?> target, @Nullable Class<?> returnType, Class<?> ... params) {
        return ReflectionUtil.getMethod(target, returnType, 0, params);
    }

    public static Method getMethod(@NotNull Class<?> target, @Nullable Class<?> returnType, int index, Class<?> ... params) {
        for (Method method : target.getDeclaredMethods()) {
            if (returnType != null && !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(method.getParameterTypes(), params) || index-- > 0) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        if (target.getSuperclass() != null) {
            return ReflectionUtil.getMethod(target.getSuperclass(), returnType, index, params);
        }
        throw new IllegalArgumentException("Cannot find field with return=" + String.valueOf(returnType) + ", params=" + Arrays.toString(params));
    }

    public static Object invokeMethod(@NotNull Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InternalError("Failed to invoke method " + String.valueOf(method) + ". This is probably caused by your minecraft server version. Contact a DEV for more help.", e);
        }
    }

    static {
        int javaVersion1;
        versionString = Bukkit.getServer() == null ? "TESTING" : MinecraftVersions.getCURRENT().toProtocolString();
        nmsVersion = "net.minecraft.server." + versionString + ".";
        boolean isPaper = Bukkit.getServer() != null && CompatibilityAPI.isPaper();
        cbVersion = isPaper && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast() ? "org.bukkit.craftbukkit." : "org.bukkit.craftbukkit." + versionString + ".";
        try {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            version = version.split("-")[0];
            javaVersion1 = Integer.parseInt(version);
        }
        catch (Throwable throwable) {
            javaVersion1 = -1;
            MechanicsCore.debug.error("Could not get Java version for '" + System.getProperty("java.version") + "'");
            MechanicsCore.debug.log(LogLevel.ERROR, throwable);
        }
        javaVersion = javaVersion1;
        modifiersField = javaVersion < 12 ? ReflectionUtil.getField(Field.class, "modifiers") : null;
    }
}

