/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProbabilityMap<E>
implements Iterable<Node<E>> {
    private final Node<E> dummy = new Node();
    private final NavigableSet<Node<E>> set = new TreeSet<Node>(Comparator.comparingDouble(Node::getOffset));
    private double totalProbability;

    public boolean add(E element, double chance) {
        if (chance <= 0.0) {
            throw new IllegalArgumentException("chance <= 0.0");
        }
        Node<E> node = new Node<E>(element, chance, this.totalProbability);
        if (this.set.add(node)) {
            this.totalProbability += chance;
            return true;
        }
        return false;
    }

    public boolean remove(E element) {
        Node<E> removedElement = null;
        Iterator<Node<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Node<E> node = iterator.next();
            if (removedElement != null) {
                node.offset -= removedElement.chance;
                continue;
            }
            if (!Objects.equals(element, node.value)) continue;
            iterator.remove();
            this.totalProbability -= node.chance;
            removedElement = node;
        }
        return removedElement != null;
    }

    @Nullable
    public E get() {
        this.dummy.offset = ThreadLocalRandom.current().nextDouble(this.totalProbability);
        Node<E> temp = this.set.floor(this.dummy);
        return temp == null ? null : (E)temp.value;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    @Override
    @NotNull
    public Iterator<Node<E>> iterator() {
        return this.set.iterator();
    }

    public static class Node<E> {
        private final E value;
        private final double chance;
        private double offset;

        Node() {
            this.value = null;
            this.chance = 0.0;
        }

        Node(E value, double chance, double offset) {
            this.chance = chance;
            this.value = value;
            this.offset = offset;
        }

        public E getValue() {
            return this.value;
        }

        public double getChance() {
            return this.chance;
        }

        public double getOffset() {
            return this.offset;
        }
    }
}

