/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.deecaad.core.utils.DoubleRef;
import me.deecaad.core.utils.FloatRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0006H\u0007J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004H\u0007J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J \u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0007J \u0010%\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J \u0010%\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J \u0010&\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J \u0010&\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J \u0010'\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0007J \u0010'\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007J \u0010)\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0007J \u0010)\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007J \u0010*\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0007J \u0010*\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007J \u0010+\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0007J \u0010+\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007J \u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0007J \u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0007J \u00100\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0007J \u00100\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0007J \u00101\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0007J \u00101\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0007J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H\u0007J\u0010\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0007J\u0010\u00104\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H\u0007J\u0010\u00104\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0007J0\u00105\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0006H\u0007J0\u00105\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0007J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0007J<\u0010;\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00062\b\b\u0002\u0010?\u001a\u00020\u00062\b\b\u0002\u0010@\u001a\u00020\u0006H\u0007J<\u0010;\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010<\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u0010?\u001a\u00020\u00042\b\b\u0002\u0010@\u001a\u00020\u0004H\u0007J<\u0010B\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00062\b\b\u0002\u0010?\u001a\u00020\u00062\b\b\u0002\u0010@\u001a\u00020\u0006H\u0007J<\u0010B\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010<\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u0010?\u001a\u00020\u00042\b\b\u0002\u0010@\u001a\u00020\u0004H\u0007J<\u0010C\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00062\b\b\u0002\u0010?\u001a\u00020\u00062\b\b\u0002\u0010@\u001a\u00020\u0006H\u0007J<\u0010C\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010<\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\b\b\u0002\u0010?\u001a\u00020\u00042\b\b\u0002\u0010@\u001a\u00020\u0004H\u0007J\u0010\u0010D\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010D\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0007J\u0010\u0010D\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001bH\u0007J\u0010\u0010E\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0007J\u0010\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lme/deecaad/core/utils/NumberUtil;", "", "()V", "EPSILON", "", "EPSILON_DOUBLE", "", "HALF_PI", "HALF_PI_DOUBLE", "NUMERALS", "Ljava/util/TreeMap;", "", "", "PI", "PI_DOUBLE", "TAU", "TAU_DOUBLE", "TIME", "approximately", "", "a", "b", "epsilon", "clamp", "value", "min", "max", "", "clamp01", "deltaDegrees", "deltaRadians", "floorToInt", "floorToLong", "fraction", "hasMillisPassed", "lastMillis", "amount", "inverseLerp", "inverseLerpUnclamped", "lerp", "t", "lerpDegrees", "lerpRadians", "lerpUnclamped", "moveTowards", "current", "target", "maxDelta", "moveTowardsDegrees", "moveTowardsRadians", "normalizeDegrees", "angle", "normalizeRadians", "remap", "from1", "to1", "from2", "to2", "signum", "smoothDamp", "currentVelocity", "Lme/deecaad/core/utils/DoubleRef;", "smoothTime", "deltaTime", "maxSpeed", "Lme/deecaad/core/utils/FloatRef;", "smoothDampDegrees", "smoothDampRadians", "square", "toRomanNumeral", "toTime", "seconds", "MechanicsCore"})
@SourceDebugExtension(value={"SMAP\nNumberUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtil.kt\nme/deecaad/core/utils/NumberUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1219:1\n1#2:1220\n*E\n"})
public final class NumberUtil {
    @NotNull
    public static final NumberUtil INSTANCE = new NumberUtil();
    public static final float EPSILON = 1.0E-6f;
    public static final double EPSILON_DOUBLE = 1.0E-6;
    public static final float PI = (float)Math.PI;
    public static final double PI_DOUBLE = Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final double HALF_PI_DOUBLE = 1.5707963267948966;
    public static final float TAU = (float)Math.PI * 2;
    public static final double TAU_DOUBLE = Math.PI * 2;
    @NotNull
    private static final TreeMap<Integer, String> NUMERALS = new TreeMap();
    @NotNull
    private static final TreeMap<Integer, String> TIME = new TreeMap();

    private NumberUtil() {
    }

    @JvmStatic
    public static final int square(int value) {
        return value * value;
    }

    @JvmStatic
    public static final float square(float value) {
        return value * value;
    }

    @JvmStatic
    public static final double square(double value) {
        return value * value;
    }

    @JvmStatic
    public static final long square(long value) {
        return value * value;
    }

    @JvmStatic
    public static final int clamp(int value, int min, int max) {
        if (!(min <= max)) {
            boolean bl = false;
            String string = "min must be less than or equal to max";
            throw new IllegalArgumentException(string.toString());
        }
        return value < min ? min : (value > max ? max : value);
    }

    @JvmStatic
    public static final float clamp(float value, float min, float max) {
        if (!(min <= max)) {
            boolean bl = false;
            String string = "min must be less than or equal to max";
            throw new IllegalArgumentException(string.toString());
        }
        return value < min ? min : (value > max ? max : value);
    }

    @JvmStatic
    public static final double clamp(double value, double min, double max) {
        if (!(min <= max)) {
            boolean bl = false;
            String string = "min must be less than or equal to max";
            throw new IllegalArgumentException(string.toString());
        }
        return value < min ? min : (value > max ? max : value);
    }

    @JvmStatic
    public static final long clamp(long value, long min, long max) {
        if (!(min <= max)) {
            boolean bl = false;
            String string = "min must be less than or equal to max";
            throw new IllegalArgumentException(string.toString());
        }
        return value < min ? min : (value > max ? max : value);
    }

    @JvmStatic
    public static final float clamp01(float value) {
        return NumberUtil.clamp(value, 0.0f, 1.0f);
    }

    @JvmStatic
    public static final double clamp01(double value) {
        return NumberUtil.clamp(value, 0.0, 1.0);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean approximately(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static /* synthetic */ boolean approximately$default(float f, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = 1.0E-6f;
        }
        return NumberUtil.approximately(f, f2, f3);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean approximately(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static /* synthetic */ boolean approximately$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0E-6;
        }
        return NumberUtil.approximately(d, d2, d3);
    }

    @JvmStatic
    public static final float lerp(float a, float b, float t) {
        return a + (b - a) * NumberUtil.clamp01(t);
    }

    @JvmStatic
    public static final double lerp(double a, double b, double t) {
        return a + (b - a) * NumberUtil.clamp01(t);
    }

    @JvmStatic
    public static final float lerpUnclamped(float a, float b, float t) {
        return a + (b - a) * t;
    }

    @JvmStatic
    public static final double lerpUnclamped(double a, double b, double t) {
        return a + (b - a) * t;
    }

    @JvmStatic
    public static final float lerpDegrees(float a, float b, float t) {
        float delta = (b - a) % 360.0f;
        return (a + delta * NumberUtil.clamp01(t)) % 360.0f;
    }

    @JvmStatic
    public static final double lerpDegrees(double a, double b, double t) {
        double delta = (b - a) % 360.0;
        return (a + delta * NumberUtil.clamp01(t)) % 360.0;
    }

    @JvmStatic
    public static final float lerpRadians(float a, float b, float t) {
        float delta = (b - a) % ((float)Math.PI * 2);
        return (a + delta * NumberUtil.clamp01(t)) % ((float)Math.PI * 2);
    }

    @JvmStatic
    public static final double lerpRadians(double a, double b, double t) {
        double delta = (b - a) % (Math.PI * 2);
        return (a + delta * NumberUtil.clamp01(t)) % (Math.PI * 2);
    }

    @JvmStatic
    public static final float inverseLerp(float a, float b, float value) {
        if (!(!(a == b))) {
            boolean bl = false;
            String string = "a and b cannot be equal";
            throw new IllegalArgumentException(string.toString());
        }
        return NumberUtil.clamp01((value - a) / (b - a));
    }

    @JvmStatic
    public static final double inverseLerp(double a, double b, double value) {
        if (!(!(a == b))) {
            boolean bl = false;
            String string = "a and b cannot be equal";
            throw new IllegalArgumentException(string.toString());
        }
        return NumberUtil.clamp01((value - a) / (b - a));
    }

    @JvmStatic
    public static final float inverseLerpUnclamped(float a, float b, float value) {
        if (!(!(a == b))) {
            boolean bl = false;
            String string = "a and b cannot be equal";
            throw new IllegalArgumentException(string.toString());
        }
        return (value - a) / (b - a);
    }

    @JvmStatic
    public static final double inverseLerpUnclamped(double a, double b, double value) {
        if (!(!(a == b))) {
            boolean bl = false;
            String string = "a and b cannot be equal";
            throw new IllegalArgumentException(string.toString());
        }
        return (value - a) / (b - a);
    }

    @JvmStatic
    public static final float remap(float value, float from1, float to1, float from2, float to2) {
        return NumberUtil.lerpUnclamped(from2, to2, NumberUtil.inverseLerpUnclamped(from1, to1, value));
    }

    @JvmStatic
    public static final double remap(double value, double from1, double to1, double from2, double to2) {
        return NumberUtil.lerpUnclamped(from2, to2, NumberUtil.inverseLerpUnclamped(from1, to1, value));
    }

    @JvmStatic
    public static final float normalizeDegrees(float angle) {
        float normalized = angle - 360.0f * (float)Math.floor((angle + 180.0f) / 360.0f);
        return normalized == -180.0f ? 180.0f : normalized;
    }

    @JvmStatic
    public static final double normalizeDegrees(double angle) {
        double normalized = angle - 360.0 * Math.floor((angle + 180.0) / 360.0);
        return normalized == -180.0 ? 180.0 : normalized;
    }

    @JvmStatic
    public static final float normalizeRadians(float angle) {
        float normalized = angle - (float)Math.PI * 2 * (float)Math.floor((angle + (float)Math.PI) / ((float)Math.PI * 2));
        return normalized == (float)(-Math.PI) ? (float)Math.PI : normalized;
    }

    @JvmStatic
    public static final double normalizeRadians(double angle) {
        double normalized = angle - Math.PI * 2 * Math.floor((angle + Math.PI) / (Math.PI * 2));
        return normalized == -Math.PI ? Math.PI : normalized;
    }

    @JvmStatic
    public static final float deltaDegrees(float a, float b) {
        return NumberUtil.normalizeDegrees(b - a);
    }

    @JvmStatic
    public static final double deltaDegrees(double a, double b) {
        return NumberUtil.normalizeDegrees(b - a);
    }

    @JvmStatic
    public static final float deltaRadians(float a, float b) {
        return NumberUtil.normalizeRadians(b - a);
    }

    @JvmStatic
    public static final double deltaRadians(double a, double b) {
        return NumberUtil.normalizeRadians(b - a);
    }

    @JvmStatic
    public static final float moveTowards(float current, float target, float maxDelta) {
        if (!(maxDelta > 0.0f)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        return Math.abs(target - current) <= maxDelta ? target : current + (float)NumberUtil.signum(target - current) * maxDelta;
    }

    @JvmStatic
    public static final double moveTowards(double current, double target, double maxDelta) {
        if (!(maxDelta > 0.0)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        return Math.abs(target - current) <= maxDelta ? target : current + (double)NumberUtil.signum(target - current) * maxDelta;
    }

    @JvmStatic
    public static final float moveTowardsDegrees(float current, float target, float maxDelta) {
        if (!((double)maxDelta > 0.0)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        float delta = NumberUtil.deltaDegrees(current, target);
        return Math.abs(delta) <= maxDelta ? target : current + (float)NumberUtil.signum(delta) * maxDelta;
    }

    @JvmStatic
    public static final double moveTowardsDegrees(double current, double target, double maxDelta) {
        if (!(maxDelta > 0.0)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        double delta = NumberUtil.deltaDegrees(current, target);
        return Math.abs(delta) <= maxDelta ? target : current + (double)NumberUtil.signum(delta) * maxDelta;
    }

    @JvmStatic
    public static final float moveTowardsRadians(float current, float target, float maxDelta) {
        if (!((double)maxDelta > 0.0)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        float delta = NumberUtil.deltaRadians(current, target);
        return Math.abs(delta) <= maxDelta ? target : current + (float)NumberUtil.signum(delta) * maxDelta;
    }

    @JvmStatic
    public static final double moveTowardsRadians(double current, double target, double maxDelta) {
        if (!(maxDelta > 0.0)) {
            boolean bl = false;
            String string = "maxDelta must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        double delta = NumberUtil.deltaRadians(current, target);
        return Math.abs(delta) <= maxDelta ? target : current + (double)NumberUtil.signum(delta) * maxDelta;
    }

    @JvmStatic
    @JvmOverloads
    public static final float smoothDamp(float current, float target, @NotNull FloatRef currentVelocity, float smoothTime, float deltaTime, float maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        float omega = 2.0f / smoothTime;
        float x = omega * deltaTime;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = current - target;
        float maxChange = maxSpeed * smoothTime;
        float clampedChange = NumberUtil.clamp(change, -maxChange, maxChange);
        float newTarget = current - clampedChange;
        float temp = (currentVelocity.getValue() + omega * clampedChange) * deltaTime;
        float newVelocity = (currentVelocity.getValue() - omega * temp) * exp;
        float newPosition = newTarget + (clampedChange + temp) * exp;
        if (target - current > 0.0f == newPosition > target) {
            newPosition = target;
            newVelocity = 0.0f;
        }
        currentVelocity.setValue(newVelocity);
        return newPosition;
    }

    public static /* synthetic */ float smoothDamp$default(float f, float f2, FloatRef floatRef, float f3, float f4, float f5, int n, Object object) {
        if ((n & 0x10) != 0) {
            f4 = 0.05f;
        }
        if ((n & 0x20) != 0) {
            f5 = Float.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDamp(f, f2, floatRef, f3, f4, f5);
    }

    @JvmStatic
    @JvmOverloads
    public static final double smoothDamp(double current, double target, @NotNull DoubleRef currentVelocity, double smoothTime, double deltaTime, double maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        double omega = (double)2 / smoothTime;
        double x = omega * deltaTime;
        double exp = 1.0 / (1.0 + x + 0.48 * x * x + 0.235 * x * x * x);
        double change = current - target;
        double maxChange = maxSpeed * smoothTime;
        double clampedChange = NumberUtil.clamp(change, -maxChange, maxChange);
        double newTarget = current - clampedChange;
        double temp = (currentVelocity.getValue() + omega * clampedChange) * deltaTime;
        double newVelocity = (currentVelocity.getValue() - omega * temp) * exp;
        double newPosition = newTarget + (clampedChange + temp) * exp;
        if (target - current > 0.0 == newPosition > target) {
            newPosition = target;
            newVelocity = 0.0;
        }
        currentVelocity.setValue(newVelocity);
        return newPosition;
    }

    public static /* synthetic */ double smoothDamp$default(double d, double d2, DoubleRef doubleRef, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d4 = 0.05;
        }
        if ((n & 0x20) != 0) {
            d5 = Double.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDamp(d, d2, doubleRef, d3, d4, d5);
    }

    @JvmStatic
    public static final float smoothDampDegrees(float current, float target, @NotNull FloatRef currentVelocity, float smoothTime, float deltaTime, float maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        float delta = NumberUtil.deltaDegrees(current, target);
        return target - NumberUtil.smoothDamp(delta, 0.0f, currentVelocity, smoothTime, deltaTime, maxSpeed);
    }

    public static /* synthetic */ float smoothDampDegrees$default(float f, float f2, FloatRef floatRef, float f3, float f4, float f5, int n, Object object) {
        if ((n & 0x10) != 0) {
            f4 = 0.05f;
        }
        if ((n & 0x20) != 0) {
            f5 = Float.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDampDegrees(f, f2, floatRef, f3, f4, f5);
    }

    @JvmStatic
    public static final double smoothDampDegrees(double current, double target, @NotNull DoubleRef currentVelocity, double smoothTime, double deltaTime, double maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        double delta = NumberUtil.deltaDegrees(current, target);
        return target - NumberUtil.smoothDamp(delta, 0.0, currentVelocity, smoothTime, deltaTime, maxSpeed);
    }

    public static /* synthetic */ double smoothDampDegrees$default(double d, double d2, DoubleRef doubleRef, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d4 = 0.05;
        }
        if ((n & 0x20) != 0) {
            d5 = Double.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDampDegrees(d, d2, doubleRef, d3, d4, d5);
    }

    @JvmStatic
    public static final float smoothDampRadians(float current, float target, @NotNull FloatRef currentVelocity, float smoothTime, float deltaTime, float maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        float delta = NumberUtil.deltaRadians(current, target);
        return target - NumberUtil.smoothDamp(delta, 0.0f, currentVelocity, smoothTime, deltaTime, maxSpeed);
    }

    public static /* synthetic */ float smoothDampRadians$default(float f, float f2, FloatRef floatRef, float f3, float f4, float f5, int n, Object object) {
        if ((n & 0x10) != 0) {
            f4 = 0.05f;
        }
        if ((n & 0x20) != 0) {
            f5 = Float.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDampRadians(f, f2, floatRef, f3, f4, f5);
    }

    @JvmStatic
    public static final double smoothDampRadians(double current, double target, @NotNull DoubleRef currentVelocity, double smoothTime, double deltaTime, double maxSpeed) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        double delta = NumberUtil.deltaRadians(current, target);
        return target - NumberUtil.smoothDamp(delta, 0.0, currentVelocity, smoothTime, deltaTime, maxSpeed);
    }

    public static /* synthetic */ double smoothDampRadians$default(double d, double d2, DoubleRef doubleRef, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d4 = 0.05;
        }
        if ((n & 0x20) != 0) {
            d5 = Double.POSITIVE_INFINITY;
        }
        return NumberUtil.smoothDampRadians(d, d2, doubleRef, d3, d4, d5);
    }

    @JvmStatic
    public static final int signum(float a) {
        return a == 0.0f ? 0 : (a > 0.0f ? 1 : -1);
    }

    @JvmStatic
    public static final int signum(double a) {
        return a == 0.0 ? 0 : (a > 0.0 ? 1 : -1);
    }

    @JvmStatic
    public static final int signum(int a) {
        return a == 0 ? 0 : (a > 0 ? 1 : -1);
    }

    @JvmStatic
    public static final long signum(long a) {
        return a == 0L ? 0L : (a > 0L ? 1L : -1L);
    }

    @JvmStatic
    public static final int floorToInt(float a) {
        int floor = (int)a;
        return a < (float)floor ? floor - 1 : floor;
    }

    @JvmStatic
    public static final int floorToInt(double a) {
        int floor = (int)a;
        return a < (double)floor ? floor - 1 : floor;
    }

    @JvmStatic
    public static final long floorToLong(float a) {
        long floor = (long)a;
        return a < (float)floor ? floor - 1L : floor;
    }

    @JvmStatic
    public static final long floorToLong(double a) {
        long floor = (long)a;
        return a < (double)floor ? floor - 1L : floor;
    }

    @JvmStatic
    public static final float fraction(float a) {
        return a - (float)NumberUtil.floorToLong(a);
    }

    @JvmStatic
    public static final double fraction(double a) {
        return a - (double)NumberUtil.floorToLong(a);
    }

    @JvmStatic
    @NotNull
    public static final String toRomanNumeral(int a) {
        Object object;
        if (a <= 0) {
            return "nulla";
        }
        Integer numeral = NUMERALS.floorKey(a);
        Integer n = numeral;
        if (n != null && a == n) {
            String string = NUMERALS.get(a);
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            object = string2;
        } else {
            String string = NUMERALS.get(numeral);
            Intrinsics.checkNotNull((Object)numeral);
            object = string + NumberUtil.toRomanNumeral(a - numeral);
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String toTime(int seconds) {
        if (seconds <= 0) {
            return "0s";
        }
        Integer unit = TIME.floorKey(seconds);
        Intrinsics.checkNotNull((Object)unit);
        int amount = seconds / unit;
        return seconds % unit == 0 ? amount + TIME.get(unit) : amount + TIME.get(unit) + " " + NumberUtil.toTime(seconds - amount * unit);
    }

    @JvmStatic
    public static final boolean hasMillisPassed(long lastMillis, long amount) {
        return System.currentTimeMillis() - lastMillis > amount;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean approximately(float a, float b) {
        return NumberUtil.approximately$default(a, b, 0.0f, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean approximately(double a, double b) {
        return NumberUtil.approximately$default(a, b, 0.0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final float smoothDamp(float current, float target, @NotNull FloatRef currentVelocity, float smoothTime, float deltaTime) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        return NumberUtil.smoothDamp$default(current, target, currentVelocity, smoothTime, deltaTime, 0.0f, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final float smoothDamp(float current, float target, @NotNull FloatRef currentVelocity, float smoothTime) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        return NumberUtil.smoothDamp$default(current, target, currentVelocity, smoothTime, 0.0f, 0.0f, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double smoothDamp(double current, double target, @NotNull DoubleRef currentVelocity, double smoothTime, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        return NumberUtil.smoothDamp$default(current, target, currentVelocity, smoothTime, deltaTime, 0.0, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final double smoothDamp(double current, double target, @NotNull DoubleRef currentVelocity, double smoothTime) {
        Intrinsics.checkNotNullParameter((Object)currentVelocity, (String)"currentVelocity");
        return NumberUtil.smoothDamp$default(current, target, currentVelocity, smoothTime, 0.0, 0.0, 48, null);
    }

    static {
        ((Map)NUMERALS).put(1000, "M");
        ((Map)NUMERALS).put(900, "CM");
        ((Map)NUMERALS).put(500, "D");
        ((Map)NUMERALS).put(400, "CD");
        ((Map)NUMERALS).put(100, "C");
        ((Map)NUMERALS).put(90, "XC");
        ((Map)NUMERALS).put(50, "L");
        ((Map)NUMERALS).put(40, "XL");
        ((Map)NUMERALS).put(10, "X");
        ((Map)NUMERALS).put(9, "IX");
        ((Map)NUMERALS).put(5, "V");
        ((Map)NUMERALS).put(4, "IV");
        ((Map)NUMERALS).put(1, "I");
        ((Map)TIME).put(31536000, "y");
        ((Map)TIME).put(86400, "d");
        ((Map)TIME).put(3600, "h");
        ((Map)TIME).put(60, "m");
        ((Map)TIME).put(1, "s");
    }
}

