/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumUtil {
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> cache = new HashMap();

    private EnumUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Enum<T>> Map<String, WeakReference<T>> getConstants(Class<T> enumClass) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = cache;
        synchronized (map) {
            Map<String, WeakReference<T>> temp = cache.get(enumClass);
            if (temp == null) {
                return EnumUtil.populateEnum(enumClass);
            }
            return temp;
        }
    }

    private static <T extends Enum<T>> Map<String, WeakReference<T>> populateEnum(Class<T> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        LinkedHashMap<String, WeakReference<T>> temp = new LinkedHashMap<String, WeakReference<T>>();
        for (Enum enumInstance : EnumSet.allOf(clazz)) {
            temp.put(enumInstance.name(), new WeakReference<Enum>(enumInstance));
        }
        cache.put(clazz, Collections.unmodifiableMap(temp));
        return temp;
    }

    public static <T extends Enum<T>> List<T> parseEnums(Class<T> clazz, String input) {
        if ((input = input.trim().toUpperCase(Locale.ROOT)).startsWith("$")) {
            ArrayList<T> list = new ArrayList<T>();
            String base = input.substring(1);
            for (String enumValue : EnumUtil.getOptions(clazz)) {
                if (!enumValue.contains(base)) continue;
                list.add(Enum.valueOf(clazz, enumValue));
            }
            return Collections.unmodifiableList(list);
        }
        Optional<Enum> enumValue = EnumUtil.getIfPresent(clazz, input);
        return enumValue.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @NotNull
    public static <T extends Enum<T>> Optional<T> getIfPresent(@NotNull Class<T> clazz, @NotNull String name) {
        WeakReference<T> reference = EnumUtil.getConstants(clazz).get(name.trim().toUpperCase(Locale.ROOT));
        return reference == null ? Optional.empty() : Optional.of((Enum)clazz.cast(reference.get()));
    }

    @Nullable
    public static <T extends Enum<T>> T getOrNull(@NotNull Class<T> clazz, @NotNull String name) {
        return (T)((Enum)EnumUtil.getIfPresent(clazz, name).orElse(null));
    }

    @NotNull
    public static <T extends Enum<T>> Set<String> getOptions(@NotNull Class<T> clazz) {
        Map<String, WeakReference<T>> temp = EnumUtil.getConstants(clazz);
        return temp.keySet();
    }

    @NotNull
    public static <T extends Enum<T>> List<T> getValues(@NotNull Class<T> clazz) {
        Map<String, WeakReference<T>> temp = EnumUtil.getConstants(clazz);
        ArrayList<Enum> list = new ArrayList<Enum>(temp.size());
        for (WeakReference<T> reference : temp.values()) {
            list.add((Enum)reference.get());
        }
        return list;
    }
}

