/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.Quaternion;
import me.deecaad.core.utils.Transform;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class EntityTransform
extends Transform {
    private final Entity entity;

    public EntityTransform(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Transform getParent() {
        return null;
    }

    @Override
    public void setParent(Transform parent) {
        throw new IllegalArgumentException("EntityTransform cannot have parent");
    }

    @Override
    public Vector getLocalPosition() {
        return this.entity.getLocation().toVector();
    }

    @Override
    public void setLocalPosition(Vector localPosition) {
        this.entity.teleport(localPosition.toLocation(this.entity.getWorld()));
    }

    @Override
    public Quaternion getLocalRotation() {
        Vector localUp = Quaternion.UP;
        Vector view = this.entity.getLocation().getDirection();
        if (localUp.equals((Object)view)) {
            localUp = Quaternion.BACKWARD;
        }
        return Quaternion.lookAt(this.entity.getLocation().getDirection(), Quaternion.UP);
    }

    @Override
    public void setLocalRotation(Quaternion localRotation) {
        Vector euler = localRotation.getEulerAngles();
        if (this.entity.getType() == EntityType.ARMOR_STAND) {
            ArmorStand stand = (ArmorStand)this.entity;
            stand.setHeadPose(new EulerAngle(euler.getX(), euler.getY(), euler.getZ()));
        } else if (MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
            this.entity.setRotation((float)euler.getX(), (float)euler.getY());
        } else {
            Location loc = this.entity.getLocation();
            loc.setYaw((float)euler.getX());
            loc.setPitch((float)euler.getY());
            this.entity.teleport(loc);
        }
    }

    @Override
    public void applyRotation(Quaternion rotation) {
        Quaternion local = this.getLocalRotation();
        local.multiply(rotation);
        this.setLocalRotation(local);
    }
}

