/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.StringUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdventureUtil {
    public static Field loreField;
    public static Field displayField;
    public static Method fromJsonMethod;
    public static Method toJsonMethod;

    private AdventureUtil() {
    }

    @NotNull
    public static Component getName(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return Component.empty();
        }
        if (MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
            Object component = ReflectionUtil.invokeField(displayField, meta);
            String json = (String)ReflectionUtil.invokeMethod(toJsonMethod, null, component);
            return GsonComponentSerializer.gson().deserialize((Object)json);
        }
        if (MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
            return GsonComponentSerializer.gson().deserialize((Object)((String)ReflectionUtil.invokeField(displayField, meta)));
        }
        return LegacyComponentSerializer.legacySection().deserialize(meta.getDisplayName());
    }

    public static void setNameUnparsed(@NotNull ItemStack item, @NotNull String name) {
        ItemMeta meta = item.getItemMeta();
        AdventureUtil.setNameUnparsed(Objects.requireNonNull(meta), name);
        item.setItemMeta(meta);
    }

    public static void setNameUnparsed(@NotNull ItemMeta meta, @NotNull String name) {
        AdventureUtil.setName(meta, MechanicsCore.getPlugin().message.deserialize((Object)("<!italic>" + name)));
    }

    public static void setName(@NotNull ItemStack item, @NotNull Component name) {
        ItemMeta meta = item.getItemMeta();
        AdventureUtil.setName(Objects.requireNonNull(meta), name);
        item.setItemMeta(meta);
    }

    public static void setName(@NotNull ItemMeta meta, @NotNull Component name) {
        if (MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
            String json = (String)GsonComponentSerializer.gson().serialize(name);
            Object component = ReflectionUtil.invokeMethod(fromJsonMethod, null, json);
            ReflectionUtil.setField(displayField, meta, component);
        } else if (MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
            String str = (String)GsonComponentSerializer.gson().serialize(name);
            ReflectionUtil.setField(displayField, meta, str);
        } else {
            String str = LegacyComponentSerializer.legacySection().serialize(name);
            meta.setDisplayName(str);
        }
    }

    @Nullable
    public static List<Component> getLore(@NotNull ItemStack item) {
        return AdventureUtil.getLore(Objects.requireNonNull(item.getItemMeta()));
    }

    @Nullable
    public static List<Component> getLore(@NotNull ItemMeta meta) {
        List lore;
        boolean useLegacy = !MinecraftVersions.NETHER_UPDATE.isAtLeast();
        List list = lore = useLegacy ? meta.getLore() : (List)ReflectionUtil.invokeField(loreField, meta);
        if (lore == null) {
            return null;
        }
        ArrayList<Component> components = new ArrayList<Component>(lore.size());
        for (String line : lore) {
            TextComponent component = useLegacy ? LegacyComponentSerializer.legacySection().deserialize(line) : GsonComponentSerializer.gson().deserialize((Object)line);
            components.add((Component)component);
        }
        return components;
    }

    public static void setLoreUnparsed(@NotNull ItemStack item, @NotNull List<?> unparsedText) {
        ItemMeta meta = item.getItemMeta();
        AdventureUtil.setLoreUnparsed(Objects.requireNonNull(meta), unparsedText);
        item.setItemMeta(meta);
    }

    public static void setLoreUnparsed(@NotNull ItemMeta meta, @NotNull List<?> unparsedText) {
        ArrayList<Object> lore = new ArrayList<Object>(unparsedText.size());
        for (Object obj : unparsedText) {
            Component component = MechanicsCore.getPlugin().message.deserialize((Object)("<!italic>" + StringUtil.colorAdventure(obj.toString())));
            if (MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
                String json = (String)GsonComponentSerializer.gson().serialize(component);
                Object componentObj = ReflectionUtil.invokeMethod(fromJsonMethod, null, json);
                lore.add(componentObj);
                continue;
            }
            if (MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
                lore.add(GsonComponentSerializer.gson().serialize(component));
                continue;
            }
            lore.add(LegacyComponentSerializer.legacySection().serialize(component));
        }
        if (!MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
            meta.setLore(lore);
        } else {
            ReflectionUtil.setField(loreField, meta, lore);
        }
    }

    public static void setLore(@NotNull ItemStack item, @NotNull List<Component> lines) {
        ItemMeta meta = item.getItemMeta();
        AdventureUtil.setLore(Objects.requireNonNull(meta), lines);
        item.setItemMeta(meta);
    }

    public static void setLore(@NotNull ItemMeta meta, @NotNull List<Component> lines) {
        ArrayList<Object> lore = new ArrayList<Object>(lines.size());
        for (Component component : lines) {
            if (MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
                String json = (String)GsonComponentSerializer.gson().serialize(component);
                Object componentObj = ReflectionUtil.invokeMethod(fromJsonMethod, null, json);
                lore.add(componentObj);
                continue;
            }
            if (MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
                lore.add(GsonComponentSerializer.gson().serialize(component));
                continue;
            }
            lore.add(LegacyComponentSerializer.legacySection().serialize(component));
        }
        if (!MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
            meta.setLore(lore);
        } else {
            ReflectionUtil.setField(loreField, meta, lore);
        }
    }

    public static void updatePlaceholders(Player player, ItemStack itemStack) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        String name = (String)GsonComponentSerializer.gson().serialize(AdventureUtil.getName(itemStack));
        name = PlaceholderAPI.setPlaceholders((Player)player, (String)name);
        AdventureUtil.setName(itemMeta, GsonComponentSerializer.gson().deserialize((Object)name));
        List<Component> lore = AdventureUtil.getLore(itemMeta);
        if (lore != null && !lore.isEmpty()) {
            ArrayList<String> loreStrings = new ArrayList<String>(lore.size());
            for (Component component : lore) {
                loreStrings.add((String)GsonComponentSerializer.gson().serialize(component));
            }
            PlaceholderAPI.setPlaceholders((Player)player, loreStrings);
            for (int i = 0; i < loreStrings.size(); ++i) {
                lore.set(i, GsonComponentSerializer.gson().deserialize((Object)((String)loreStrings.get(i))));
            }
            AdventureUtil.setLore(itemMeta, lore);
        }
        itemStack.setItemMeta(itemMeta);
    }

    static {
        Class<?> c;
        if (MinecraftVersions.NETHER_UPDATE.isAtLeast()) {
            c = ReflectionUtil.getCBClass("inventory.CraftMetaItem");
            loreField = ReflectionUtil.getField(c, "lore");
            displayField = ReflectionUtil.getField(c, "displayName");
        }
        if (MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
            c = ReflectionUtil.getCBClass("util.CraftChatMessage");
            Class<?> componentClass = ReflectionUtil.getNMSClass("network.chat", "IChatBaseComponent");
            fromJsonMethod = ReflectionUtil.getMethod(c, "fromJSON", String.class);
            toJsonMethod = ReflectionUtil.getMethod(c, "toJSON", componentClass);
        }
    }
}

