/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.placeholder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.placeholder.PlaceholderRequestEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlaceholderMessageChain {
    private final List<PlaceholderMessage> chain;

    public PlaceholderMessageChain(PlaceholderMessage ... chain) {
        this.chain = Arrays.asList(chain);
    }

    public PlaceholderMessageChain(List<PlaceholderMessage> chain) {
        this.chain = chain;
    }

    public List<PlaceholderMessage> getChain() {
        return this.chain;
    }

    public TagResolver[] getTagResolvers(PlaceholderData data) {
        for (PlaceholderMessage message : this.chain) {
            message.fillMap(data);
        }
        PlaceholderRequestEvent event = new PlaceholderRequestEvent(data);
        Bukkit.getPluginManager().callEvent((Event)event);
        Map<String, String> placeholders = event.placeholders();
        TagResolver[] tagResolvers = new TagResolver[event.placeholders().size()];
        int i = 0;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            tagResolvers[i++] = Placeholder.parsed((String)entry.getKey(), (String)entry.getValue());
        }
        return tagResolvers;
    }

    public List<Component> replaceAndDeserialize(PlaceholderData data) {
        TagResolver[] tagResolvers = this.getTagResolvers(data);
        boolean isPlaceholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        ArrayList<Component> temp = new ArrayList<Component>(this.chain.size());
        for (PlaceholderMessage message : this.chain) {
            String str = message.getTemplate();
            if (isPlaceholderAPI) {
                str = PlaceholderAPI.setPlaceholders((Player)data.player(), (String)str);
            }
            temp.add(MechanicsCore.getPlugin().message.deserialize(str, tagResolvers));
        }
        return temp;
    }

    public TextComponent.Builder replaceAndDeserializeAndMerge(PlaceholderData data) {
        TagResolver[] tagResolvers = this.getTagResolvers(data);
        boolean isPlaceholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        TextComponent.Builder builder = Component.text();
        for (PlaceholderMessage message : this.chain) {
            String str = message.getTemplate();
            if (isPlaceholderAPI) {
                str = PlaceholderAPI.setPlaceholders((Player)data.player(), (String)str);
            }
            builder.append(MechanicsCore.getPlugin().message.deserialize(str, tagResolvers));
        }
        return builder;
    }
}

