/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.placeholder;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlaceholderData {
    @Nullable
    default public Player player() {
        return null;
    }

    @Nullable
    default public ItemStack item() {
        return null;
    }

    @Nullable
    default public String itemTitle() {
        return null;
    }

    @Nullable
    default public EquipmentSlot slot() {
        return null;
    }

    @NotNull
    public Map<String, String> placeholders();

    public static Builder builder() {
        return new Builder();
    }

    public static PlaceholderData of(@Nullable Player player, @Nullable ItemStack item, @Nullable String itemTitle, @Nullable EquipmentSlot slot) {
        return new Direct(player, item, itemTitle, slot, new HashMap<String, String>());
    }

    public static PlaceholderData of(@Nullable Player player, @Nullable ItemStack item, @Nullable String itemTitle, @Nullable EquipmentSlot slot, @NotNull Map<String, String> tempPlaceholders) {
        return new Direct(player, item, itemTitle, slot, tempPlaceholders);
    }

    public static class Builder
    implements PlaceholderData {
        @Nullable
        private Player player;
        @Nullable
        private ItemStack item;
        @Nullable
        private String itemTitle;
        @Nullable
        private EquipmentSlot slot;
        @NotNull
        private final Map<String, String> placeholders = new HashMap<String, String>();

        @Contract(value="_ -> this")
        @NotNull
        public Builder setPlayer(@Nullable Player player) {
            this.player = player;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder setItem(@Nullable ItemStack item) {
            this.item = item;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder setItemTitle(@Nullable String itemTitle) {
            this.itemTitle = itemTitle;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder setSlot(@Nullable EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder setPlaceholder(@NotNull String placeholder, @NotNull String value) {
            this.placeholders.put(placeholder, value);
            return this;
        }

        @Override
        public Player player() {
            return this.player;
        }

        @Override
        public ItemStack item() {
            return this.item;
        }

        @Override
        public String itemTitle() {
            return this.itemTitle;
        }

        @Override
        public EquipmentSlot slot() {
            return this.slot;
        }

        @Override
        @NotNull
        public Map<String, String> placeholders() {
            return this.placeholders;
        }
    }

    public record Direct(@Nullable Player player, @Nullable ItemStack item, @Nullable String itemTitle, @Nullable EquipmentSlot slot, @NotNull Map<String, String> placeholders) implements PlaceholderData
    {
    }
}

