/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.placeholder;

import java.util.Locale;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.nbt.NBTCompatibility;
import me.deecaad.core.placeholder.NumericPlaceholderHandler;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.utils.AttributeType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttributePlaceholderHandler
extends NumericPlaceholderHandler {
    private final AttributeType attribute;

    public AttributePlaceholderHandler(AttributeType attribute) {
        super("item_" + attribute.name().toLowerCase(Locale.ROOT));
        this.attribute = attribute;
    }

    @Override
    @Nullable
    public Number requestValue(@NotNull PlaceholderData data) {
        NBTCompatibility.AttributeSlot attributeSlot;
        ItemStack item = data.item();
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        EquipmentSlot equipmentSlot = data.slot();
        if (equipmentSlot == null) {
            attributeSlot = null;
        } else {
            switch (equipmentSlot) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case HAND: {
                    attributeSlot = NBTCompatibility.AttributeSlot.MAIN_HAND;
                    break;
                }
                case OFF_HAND: {
                    attributeSlot = NBTCompatibility.AttributeSlot.OFF_HAND;
                    break;
                }
                case FEET: {
                    attributeSlot = NBTCompatibility.AttributeSlot.FEET;
                    break;
                }
                case LEGS: {
                    attributeSlot = NBTCompatibility.AttributeSlot.LEGS;
                    break;
                }
                case CHEST: {
                    attributeSlot = NBTCompatibility.AttributeSlot.CHEST;
                    break;
                }
                case HEAD: {
                    attributeSlot = NBTCompatibility.AttributeSlot.HEAD;
                    break;
                }
                case BODY: {
                    attributeSlot = NBTCompatibility.AttributeSlot.BODY;
                }
            }
        }
        NBTCompatibility.AttributeSlot slot = attributeSlot;
        return CompatibilityAPI.getNBTCompatibility().getAttributeValue(item, this.attribute, slot);
    }
}

