/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.targeters;

import java.util.Collections;
import java.util.Iterator;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.targeters.Targeter;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTargeter
extends Targeter {
    private String worldName;
    private World worldCache;

    public WorldTargeter() {
    }

    public WorldTargeter(String worldName) {
        this.worldName = worldName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public World getWorldCache() {
        return this.worldCache;
    }

    public void setWorldCache(World worldCache) {
        this.worldCache = worldCache;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public Iterator<CastData> getTargets0(final CastData cast) {
        if (this.worldCache == null || this.worldName == null) {
            World world = this.worldCache = this.worldName == null ? cast.getSource().getWorld() : Bukkit.getWorld((String)this.worldName);
        }
        if (this.worldCache == null) {
            MechanicsCore.debug.warn("There was an error getting the world for '" + this.worldName + "'");
            return Collections.emptyIterator();
        }
        final Iterator entityIterator = this.worldCache.getLivingEntities().iterator();
        return new Iterator<CastData>(){

            @Override
            public boolean hasNext() {
                return entityIterator.hasNext();
            }

            @Override
            public CastData next() {
                cast.setTargetEntity((LivingEntity)entityIterator.next());
                return cast;
            }
        };
    }

    @Override
    public String getKeyword() {
        return "World";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/targeters/world";
    }

    @Override
    @NotNull
    public Targeter serialize(@NotNull SerializeData data) throws SerializerException {
        String worldName = data.of("World").assertType(String.class).get(null);
        return this.applyParentArgs(data, new WorldTargeter(worldName));
    }

    public boolean isDefaultValues() {
        return !this.isEye() && this.getOffset() == null && this.worldName == null;
    }
}

