/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.targeters;

import java.util.Iterator;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.VectorSerializer;
import me.deecaad.core.mechanics.CastData;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;

public abstract class Targeter
implements InlineSerializer<Targeter> {
    private boolean eye;
    private VectorSerializer offset;

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/#targeter";
    }

    public boolean isEye() {
        return this.eye;
    }

    @Nullable
    public VectorSerializer getOffset() {
        return this.offset;
    }

    public abstract boolean isEntity();

    public final Iterator<CastData> getTargets(CastData cast) {
        final Iterator<CastData> targets = this.getTargets0(cast);
        if (this.offset != null || this.eye) {
            return new Iterator<CastData>(){

                @Override
                public boolean hasNext() {
                    return targets.hasNext();
                }

                @Override
                public CastData next() {
                    Location origin;
                    CastData target = (CastData)targets.next();
                    Location location = origin = Targeter.this.eye && target.getTarget() != null ? target.getTarget().getEyeLocation() : target.getTargetLocation();
                    if (Targeter.this.offset != null) {
                        origin.add(Targeter.this.offset.getVector(target.getTarget()));
                    }
                    target.setTargetLocation(origin);
                    return target;
                }
            };
        }
        return targets;
    }

    protected abstract Iterator<CastData> getTargets0(CastData var1);

    protected Targeter applyParentArgs(SerializeData data, Targeter targeter) throws SerializerException {
        VectorSerializer offset = data.of("Offset").serialize(VectorSerializer.class);
        if (!this.isEntity() && offset != null && offset.isRelative()) {
            throw data.exception("offset", "Did you try to use relative locations ('~') with '" + this.getInlineKeyword() + "'?", this.getInlineKeyword() + " is a LOCATION targeter, so it cannot use relative locations.");
        }
        targeter.offset = offset;
        targeter.eye = data.of("Eye").getBool(false);
        return targeter;
    }
}

