/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.targeters;

import java.util.Iterator;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.targeters.EmptyIterator;
import me.deecaad.core.mechanics.targeters.ShapeTargeter;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.utils.RandomUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ScatterTargeter
extends ShapeTargeter {
    private int points;
    private double horizontalRange;
    private double verticalRange;
    private boolean isTraceDown;

    public ScatterTargeter() {
    }

    public ScatterTargeter(int points, double horizontalRange, double verticalRange, boolean isTraceDown) {
        this.points = points;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.isTraceDown = isTraceDown;
    }

    @Override
    @NotNull
    public Iterator<Vector> getPoints(@NotNull CastData cast) {
        final Location origin = cast.getTargetLocation();
        final World world = cast.getTargetWorld();
        if (origin == null || world == null) {
            MechanicsCore.debug.error("Tried to use useTarget=true with Scatter{}, but there was no target");
            return EmptyIterator.emptyIterator();
        }
        int maxAttempts = 5;
        return new Iterator<Vector>(){
            final Vector cache = new Vector();
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ScatterTargeter.this.points;
            }

            @Override
            public Vector next() {
                double z;
                double y;
                double x;
                ++this.i;
                int attempts = 0;
                do {
                    x = RandomUtil.range(-ScatterTargeter.this.horizontalRange, ScatterTargeter.this.horizontalRange);
                    y = RandomUtil.range(-ScatterTargeter.this.verticalRange, ScatterTargeter.this.verticalRange);
                    z = RandomUtil.range(-ScatterTargeter.this.horizontalRange, ScatterTargeter.this.horizontalRange);
                } while (ScatterTargeter.this.isTraceDown && attempts++ < 5 && !ScatterTargeter.isEmpty(world, origin, x, y, z));
                int dy = 0;
                while (ScatterTargeter.this.isTraceDown) {
                    int n = dy++;
                    if (!((double)n < ScatterTargeter.this.verticalRange) || !ScatterTargeter.isEmpty(world, origin, x, y, z)) break;
                    y -= 1.0;
                    ++dy;
                }
                if (ScatterTargeter.this.isTraceDown) {
                    y = Math.floor(y + 1.0) + 0.05;
                }
                this.cache.setX(x);
                this.cache.setY(y);
                this.cache.setZ(z);
                return this.cache;
            }
        };
    }

    private static boolean isEmpty(World world, Location origin, double x, double y, double z) {
        return world.getBlockAt((int)(origin.getX() + x), (int)(origin.getY() + y), (int)(origin.getZ() + z)).isEmpty();
    }

    @Override
    public String getKeyword() {
        return "Scatter";
    }

    @Override
    @NotNull
    public Targeter serialize(@NotNull SerializeData data) throws SerializerException {
        int points = data.of("Points").assertExists().getInt();
        double horizontalRange = data.of("Horizontal_Range").assertPositive().getDouble(5.0);
        double verticalRange = data.of("Vertical_Range").assertPositive().getDouble(horizontalRange);
        boolean isTraceDown = data.of("Trace_Down").getBool(false);
        return this.applyParentArgs(data, new ScatterTargeter(points, horizontalRange / 2.0, verticalRange / 2.0, isTraceDown));
    }
}

