/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.time.Duration;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.placeholder.PlaceholderMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleMechanic
extends Mechanic {
    @Nullable
    private PlaceholderMessage title;
    @Nullable
    private PlaceholderMessage subtitle;
    private Title.Times times;

    public TitleMechanic() {
    }

    public TitleMechanic(@Nullable String title, @Nullable String subtitle, @NotNull Title.Times times) {
        this.title = title == null ? null : new PlaceholderMessage(title);
        this.subtitle = subtitle == null ? null : new PlaceholderMessage(subtitle);
        this.times = times;
    }

    @Nullable
    public PlaceholderMessage getTitle() {
        return this.title;
    }

    @Nullable
    public PlaceholderMessage getSubtitle() {
        return this.subtitle;
    }

    @NotNull
    public Title.Times getTimes() {
        return this.times;
    }

    @Override
    public void use0(CastData cast) {
        LivingEntity livingEntity = cast.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        TextComponent titleComponent = this.title == null ? Component.empty() : this.title.replaceAndDeserialize(cast);
        TextComponent subtitleComponent = this.subtitle == null ? Component.empty() : this.subtitle.replaceAndDeserialize(cast);
        Title title = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)this.times);
        Audience audience = MechanicsCore.getPlugin().adventure.player(player);
        audience.showTitle(title);
    }

    @Override
    public String getKeyword() {
        return "Title";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/title";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String title = data.of("Title").getAdventure(null);
        String subtitle = data.of("Subtitle").getAdventure(null);
        int fadeIn = data.of("Fade_In").assertPositive().getInt(10);
        int stay = data.of("Stay").assertPositive().getInt(70);
        int fadeOut = data.of("Fade_Out").assertPositive().getInt(20);
        if (title == null && subtitle == null) {
            throw data.exception(null, "Missing both 'title' and 'subtitle' options");
        }
        Title.Times times = Title.Times.times((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeOut));
        return this.applyParentArgs(data, new TitleMechanic(title, subtitle, times));
    }
}

