/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.ActivateBlockMechanic;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.block.SculkShrieker;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SculkShriekMechanic
extends ActivateBlockMechanic<SculkShrieker>
implements JarSearcherExempt {
    public SculkShriekMechanic() {
        super(SculkShrieker.class);
    }

    @Override
    @Nullable
    public String getKeyword() {
        return "SculkShriek";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/sculk-shriek";
    }

    @Override
    protected void use0(CastData cast) {
        LivingEntity target = cast.getTarget();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        this.forEachBlock(player.getLocation(), shrieker -> shrieker.tryShriek(player));
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        if (!MinecraftVersions.TRAILS_AND_TAILS.get(2).isAtLeast()) {
            throw data.exception(null, "The SculkShriek{} Mechanic is only available in 1.20.2+");
        }
        return this.applyParentArgs(data, new SculkShriekMechanic());
    }
}

