/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.ActivateBlockMechanic;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.Location;
import org.bukkit.block.SculkCatalyst;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SculkBloomMechanic
extends ActivateBlockMechanic<SculkCatalyst>
implements JarSearcherExempt {
    private int charge;

    public SculkBloomMechanic() {
        super(SculkCatalyst.class);
    }

    public SculkBloomMechanic(int charge) {
        super(SculkCatalyst.class);
        this.charge = charge;
    }

    @Override
    @Nullable
    public String getKeyword() {
        return "SculkBloom";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/sculk-bloom";
    }

    @Override
    protected void use0(CastData cast) {
        Location target = cast.getTargetLocation();
        if (target == null) {
            return;
        }
        this.forEachBlock(target, catalyst -> catalyst.bloom(target.getBlock(), this.charge));
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        if (!MinecraftVersions.TRAILS_AND_TAILS.get(2).isAtLeast()) {
            throw data.exception(null, "The SculkBloom{} Mechanic is only available in 1.20.2+");
        }
        int charge = data.of("Charge").assertRange(1, 32000).getInt(5);
        return this.applyParentArgs(data, new SculkBloomMechanic(charge));
    }
}

