/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.util.ArrayList;
import java.util.Locale;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.NamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionMechanic
extends Mechanic {
    private PotionEffect potion;

    public PotionMechanic() {
    }

    public PotionMechanic(PotionEffect potion) {
        this.potion = potion;
    }

    public PotionEffect getPotion() {
        return this.potion;
    }

    @Override
    public void use0(CastData cast) {
        if (cast.getTarget() == null) {
            return;
        }
        cast.getTarget().addPotionEffect(this.potion);
    }

    @Override
    public String getKeyword() {
        return "Potion";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/potion";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        boolean showIcon;
        String potionStr = data.of("Potion").assertExists().assertType(String.class).get().toString().trim();
        String potionLower = potionStr.toLowerCase(Locale.ROOT);
        PotionEffectType potion = PotionEffectType.getByName((String)potionStr.toUpperCase(Locale.ROOT));
        int time = data.of("Time").assertPositive().getInt(100);
        int amplifier = data.of("Level").assertPositive().getInt(1) - 1;
        boolean ambient = data.of("Particles").getEnum(ParticleMode.class, ParticleMode.NORMAL) == ParticleMode.AMBIENT;
        boolean showParticles = data.of("Particles").getEnum(ParticleMode.class, ParticleMode.NORMAL) != ParticleMode.HIDE;
        boolean bl = showIcon = !data.of("Hide_Icon").getBool(false);
        if (potion == null && MinecraftVersions.CAVES_AND_CLIFFS_2.isAtLeast()) {
            potion = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.fromString((String)potionLower));
        }
        if (potion == null) {
            potion = PotionEffectType.getByName((String)potionLower);
        }
        if (potion == null) {
            ArrayList<String> options = new ArrayList<String>();
            for (PotionEffectType type : PotionEffectType.values()) {
                options.add(type.getName());
                if (!MinecraftVersions.CAVES_AND_CLIFFS_2.isAtLeast()) continue;
                options.add(type.getKey().getKey());
            }
            throw new SerializerOptionsException(this, "Potion", options, potionStr, data.of("Potion").getLocation());
        }
        PotionEffect effect = MinecraftVersions.VILLAGE_AND_PILLAGE.isAtLeast() ? new PotionEffect(potion, time, amplifier, ambient, showParticles, showIcon) : new PotionEffect(potion, time, amplifier, ambient, showParticles);
        return this.applyParentArgs(data, new PotionMechanic(effect));
    }

    public static enum ParticleMode {
        HIDE,
        NORMAL,
        AMBIENT;

    }
}

