/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.utils.VectorUtil;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeapMechanic
extends Mechanic {
    private double speed;
    private double verticalMultiplier;

    public LeapMechanic() {
    }

    public LeapMechanic(double speed, double verticalMultiplier) {
        this.speed = speed;
        this.verticalMultiplier = verticalMultiplier;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getVerticalMultiplier() {
        return this.verticalMultiplier;
    }

    @Override
    protected void use0(CastData cast) {
        Vector velocity = cast.getTargetLocation().subtract(cast.getSourceLocation()).toVector();
        if (VectorUtil.isZero(velocity)) {
            return;
        }
        velocity.setY(velocity.getY() * this.verticalMultiplier);
        velocity.normalize().multiply(this.speed);
        cast.getSource().setVelocity(velocity);
    }

    @Override
    public String getKeyword() {
        return "Leap";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/leap";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        double speed = data.of("Speed").assertExists().getDouble();
        double verticalMultiplier = data.of("Vertical_Multiplier").getDouble(1.0);
        return this.applyParentArgs(data, new LeapMechanic(speed, verticalMultiplier));
    }
}

