/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.mechanics.PlayerEffectMechanic;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.mechanics.targeters.WorldTargeter;
import me.deecaad.core.utils.RandomUtil;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSoundMechanic
extends PlayerEffectMechanic {
    private String sound;
    private float volume;
    private float pitch;
    private float noise;
    private SoundCategory category;
    private Targeter listeners;
    private List<Condition> listenerConditions;

    public CustomSoundMechanic() {
    }

    public CustomSoundMechanic(String sound, float volume, float pitch, float noise, SoundCategory category, Targeter listeners, List<Condition> listenerConditions) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.noise = noise;
        this.category = category;
        this.listeners = listeners;
        this.listenerConditions = listenerConditions;
    }

    public String getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getNoise() {
        return this.noise;
    }

    public Object getCategory() {
        return this.category;
    }

    public Targeter getListeners() {
        return this.listeners;
    }

    public List<Condition> getListenerConditions() {
        return this.listenerConditions;
    }

    @Override
    protected void use0(CastData cast) {
        if (this.listeners == null) {
            Location loc = cast.getTargetLocation();
            loc.getWorld().playSound(loc, this.sound, this.category, this.volume, this.pitch + RandomUtil.range(-this.noise, this.noise));
            return;
        }
        CastData center = cast;
        if (cast.hasTargetLocation()) {
            center = center.clone();
            center.setTargetLocation((Supplier<Location>)null);
        }
        Location targetLocation = cast.getTargetLocation();
        float pitch = this.pitch + RandomUtil.range(-this.noise, this.noise);
        Iterator<CastData> it = this.listeners.getTargets(center);
        block0: while (it.hasNext()) {
            CastData target = it.next();
            LivingEntity livingEntity = target.getTarget();
            if (!(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            for (Condition condition : this.listenerConditions) {
                if (condition.isAllowed(target)) continue;
                continue block0;
            }
            player.playSound(targetLocation, this.sound, this.category, this.volume, pitch);
        }
    }

    @Override
    public String getKeyword() {
        return "Custom_Sound";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/custom-sound";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String sound = (String)data.of("Sound").assertExists().assertType(String.class).get();
        float volume = (float)data.of("Volume").assertPositive().getDouble(1.0);
        float pitch = (float)data.of("Pitch").assertRange(0.5, 2.0).getDouble(1.0);
        float noise = (float)data.of("Noise").assertRange(0.0, 1.5).getDouble(0.0);
        SoundCategory category = data.of("Category").getEnum(SoundCategory.class, SoundCategory.PLAYERS);
        Targeter listeners = data.of("Listeners").getRegistry(Mechanics.TARGETERS, null);
        List<Condition> listenerConditions = data.of("Listener_Conditions").getRegistryList(Mechanics.CONDITIONS);
        if (!listenerConditions.isEmpty() && listeners == null) {
            listeners = new WorldTargeter();
        }
        return this.applyParentArgs(data, new CustomSoundMechanic(sound, volume, pitch, noise, category, listeners, listenerConditions));
    }

    @Override
    public void playFor(CastData cast, List<Player> viewers) {
        Location targetLocation = cast.getTargetLocation();
        float pitch = this.pitch + RandomUtil.range(-this.noise, this.noise);
        for (Player player : viewers) {
            player.playSound(targetLocation, this.sound, this.category, this.volume, pitch);
        }
    }

    @Override
    @Nullable
    public Targeter getViewerTargeter() {
        return this.listeners;
    }

    @Override
    public List<Condition> getViewerConditions() {
        return this.listenerConditions;
    }
}

