/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ChanceSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.placeholder.PlaceholderMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossBarMechanic
extends Mechanic {
    private PlaceholderMessage title;
    private BossBar.Color color;
    private BossBar.Overlay style;
    private float progress;
    private int time;

    public BossBarMechanic() {
    }

    public BossBarMechanic(String title, BossBar.Color color, BossBar.Overlay style, float progress, int time) {
        this.title = new PlaceholderMessage(title);
        this.color = color;
        this.style = style;
        this.progress = progress;
        this.time = time;
    }

    public String getTitle() {
        return this.title.getTemplate();
    }

    public BossBar.Color getColor() {
        return this.color;
    }

    public BossBar.Overlay getStyle() {
        return this.style;
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public void use0(CastData cast) {
        LivingEntity livingEntity = cast.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Component chat = this.title.replaceAndDeserialize(cast);
        final Audience audience = MechanicsCore.getPlugin().adventure.player(player);
        final BossBar bossBar = BossBar.bossBar((Component)chat, (float)this.progress, (BossBar.Color)this.color, (BossBar.Overlay)this.style);
        audience.showBossBar(bossBar);
        new BukkitRunnable(){

            public void run() {
                audience.hideBossBar(bossBar);
            }
        }.runTaskLater((Plugin)MechanicsCore.getPlugin(), (long)this.time);
    }

    @Override
    public String getKeyword() {
        return "Boss_Bar";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/boss-bar";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String title = data.of("Title").assertExists().getAdventure();
        BossBar.Color color = data.of("Color").getEnum(BossBar.Color.class, BossBar.Color.RED);
        BossBar.Overlay style = data.of("Style").getEnum(BossBar.Overlay.class, BossBar.Overlay.PROGRESS);
        Double progressTemp = data.of("Progress").serialize(new ChanceSerializer());
        float progress = progressTemp == null ? 1.0f : progressTemp.floatValue();
        int time = data.of("Time").assertPositive().getInt(100);
        return this.applyParentArgs(data, new BossBarMechanic(title, color, style, progress, time));
    }
}

