/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.util.PriorityQueue;
import java.util.function.Consumer;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ActivateBlockMechanic<T extends BlockState>
extends Mechanic {
    private final Class<T> blockClass;
    private int searchRadius;
    private int maxBlocks;

    public ActivateBlockMechanic(@NotNull Class<T> blockClass) {
        this.blockClass = blockClass;
    }

    public Class<T> getBlockClass() {
        return this.blockClass;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public void forEachBlock(@NotNull Location origin, @NotNull Consumer<T> blockFunction) {
        PriorityQueue<TileEntityDistance<BlockState>> closestEntities = new PriorityQueue<TileEntityDistance<BlockState>>();
        Chunk originChunk = origin.getChunk();
        for (int dx = -this.searchRadius; dx <= this.searchRadius; dx += 16) {
            for (int dz = -this.searchRadius; dz <= this.searchRadius; dz += 16) {
                int chunkX = originChunk.getX() + dx >> 4;
                int chunkZ = originChunk.getZ() + dz >> 4;
                Chunk chunk = origin.getWorld().getChunkAt(chunkX, chunkZ);
                for (BlockState state : chunk.getTileEntities()) {
                    if (!this.blockClass.isInstance(state)) continue;
                    double dxState = (double)state.getX() - origin.getX();
                    double dyState = (double)state.getY() - origin.getY();
                    double dzState = (double)state.getZ() - origin.getZ();
                    if (!(dxState >= (double)(-this.searchRadius)) || !(dxState <= (double)this.searchRadius) || !(dyState >= (double)(-this.searchRadius)) || !(dyState <= (double)this.searchRadius) || !(dzState >= (double)(-this.searchRadius)) || !(dzState <= (double)this.searchRadius)) continue;
                    double squaredDistance = dxState * dxState + dyState * dyState + dzState * dzState;
                    closestEntities.add(new TileEntityDistance<BlockState>((BlockState)this.blockClass.cast(state), squaredDistance));
                }
            }
        }
        for (int i = 0; i < this.maxBlocks && !closestEntities.isEmpty(); ++i) {
            BlockState tileEntity = (BlockState)((TileEntityDistance)closestEntities.poll()).tileEntity();
            blockFunction.accept(tileEntity);
        }
    }

    @Override
    public Mechanic applyParentArgs(SerializeData data, Mechanic mechanic) throws SerializerException {
        ActivateBlockMechanic blockMechanic = (ActivateBlockMechanic)super.applyParentArgs(data, mechanic);
        blockMechanic.maxBlocks = data.of("Max_Blocks").assertPositive().getInt(1);
        blockMechanic.searchRadius = (int)Math.ceil(data.of("Search_Radius").assertPositive().getDouble(8.0));
        return blockMechanic;
    }

    private record TileEntityDistance<T>(T tileEntity, double squaredDistance) implements Comparable<TileEntityDistance<T>>
    {
        @Override
        public int compareTo(TileEntityDistance<T> other) {
            return Double.compare(this.squaredDistance, other.squaredDistance);
        }
    }
}

