/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import java.util.OptionalDouble;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeCondition
extends Condition {
    private OptionalDouble minSquared;
    private OptionalDouble maxSquared;

    public RangeCondition() {
    }

    public RangeCondition(OptionalDouble minSquared, OptionalDouble maxSquared) {
        this.minSquared = minSquared;
        this.maxSquared = maxSquared;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        double distanceSquared = cast.getTargetLocation().distanceSquared(cast.getSourceLocation());
        if (this.minSquared.isPresent() && distanceSquared < this.minSquared.getAsDouble()) {
            return false;
        }
        return !this.maxSquared.isPresent() || !(distanceSquared >= this.maxSquared.getAsDouble());
    }

    @Override
    public String getKeyword() {
        return "Range";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/range";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        double minNum = data.of("Min").assertPositive().getDouble(-1.0);
        double maxNum = data.of("Max").assertPositive().getDouble(-1.0);
        OptionalDouble min = data.has("Min") ? OptionalDouble.of(minNum * minNum) : OptionalDouble.empty();
        OptionalDouble max = data.has("Max") ? OptionalDouble.of(maxNum * maxNum) : OptionalDouble.empty();
        return this.applyParentArgs(data, new RangeCondition(min, max));
    }
}

