/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialCategoryCondition
extends Condition {
    private MaterialCategory category;

    public MaterialCategoryCondition() {
    }

    public MaterialCategoryCondition(MaterialCategory category) {
        this.category = category;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        return this.category.test(cast.getTargetLocation().getBlock());
    }

    @Override
    public String getKeyword() {
        return "Material_Category";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/material-category";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        MaterialCategory category = data.of("Category").assertExists().getEnum(MaterialCategory.class);
        return this.applyParentArgs(data, new MaterialCategoryCondition(category));
    }

    public static enum MaterialCategory {
        ALL{

            @Override
            public boolean test(Block block) {
                return true;
            }
        }
        ,
        AIR{

            @Override
            public boolean test(Block block) {
                return !FLUID.test(block) && !CAVE_AIR.test(block) && !VOID_AIR.test(block);
            }
        }
        ,
        FLUID{

            @Override
            public boolean test(Block block) {
                if (!MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
                    return block.isLiquid();
                }
                if (block.isLiquid()) {
                    return true;
                }
                if (block.getBlockData() instanceof Waterlogged) {
                    return ((Waterlogged)block.getBlockData()).isWaterlogged();
                }
                return false;
            }
        }
        ,
        CAVE_AIR{

            @Override
            public boolean test(Block block) {
                return MinecraftVersions.UPDATE_AQUATIC.isAtLeast() && block.getType() == Material.CAVE_AIR;
            }
        }
        ,
        VOID_AIR{

            @Override
            public boolean test(Block block) {
                return MinecraftVersions.UPDATE_AQUATIC.isAtLeast() && block.getType() == Material.VOID_AIR;
            }
        };


        public abstract boolean test(Block var1);

        public boolean test(Player player) {
            return this.test(player.getEyeLocation().getBlock());
        }
    }
}

