/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightLevelCondition
extends Condition {
    private LightLevelMode mode;
    private int min;
    private int max;

    public LightLevelCondition() {
    }

    public LightLevelCondition(LightLevelMode mode, int min, int max) {
        this.mode = mode;
        this.min = min;
        this.max = max;
    }

    public LightLevelMode getMode() {
        return this.mode;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        Block block = cast.getTargetLocation().getBlock();
        int light = this.mode.getLightLevel(block);
        return this.min <= light && this.max >= light;
    }

    @Override
    public String getKeyword() {
        return "LightLevel";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/light-level";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        LightLevelMode mode = data.of("Mode").getEnum(LightLevelMode.class, LightLevelMode.BOTH);
        int min = data.of("Min").getInt(0);
        int max = data.of("Max").getInt(15);
        return this.applyParentArgs(data, new LightLevelCondition(mode, min, max));
    }

    public static enum LightLevelMode {
        SKY{

            @Override
            int getLightLevel(Block block) {
                return block.getLightFromSky();
            }
        }
        ,
        BLOCK{

            @Override
            int getLightLevel(Block block) {
                return block.getLightFromBlocks();
            }
        }
        ,
        BOTH{

            @Override
            int getLightLevel(Block block) {
                return block.getLightLevel();
            }
        };


        abstract int getLightLevel(Block var1);
    }
}

