/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.geysermc.geyser.api.GeyserApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeyserCondition
extends Condition {
    @Override
    public boolean isAllowed0(CastData cast) {
        if (cast.getTarget() == null) {
            return false;
        }
        try {
            return GeyserApi.api().isBedrockPlayer(cast.getTarget().getUniqueId());
        }
        catch (Throwable ex) {
            MechanicsCore.debug.error("Tried to use GeyserCondition but GeyserMC is not installed!");
            return false;
        }
    }

    @Override
    public String getKeyword() {
        return "Geyser";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/integrations/geysermc#geyser-condition";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        return this.applyParentArgs(data, new GeyserCondition());
    }
}

