/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTypeCondition
extends Condition {
    private EntityType type;

    public EntityTypeCondition() {
    }

    public EntityTypeCondition(EntityType type) {
        this.type = type;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        return cast.getTarget() != null && cast.getTarget().getType() == this.type;
    }

    @Override
    public String getKeyword() {
        return "EntityType";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/entity-type";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        EntityType type = data.of("Entity").assertExists().getEnum(EntityType.class);
        return this.applyParentArgs(data, new EntityTypeCondition(type));
    }
}

