/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeCondition
extends Condition {
    private Biome biome;

    public BiomeCondition() {
    }

    public BiomeCondition(Biome biome) {
        this.biome = biome;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        return cast.getTargetLocation().getBlock().getBiome() == this.biome;
    }

    @Override
    public String getKeyword() {
        return "Biome";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/biome";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        Biome biome = data.of("Biome").assertExists().getEnum(Biome.class);
        return this.applyParentArgs(data, new BiomeCondition(biome));
    }
}

