/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.MapConfigLike;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.PlayerEffectMechanic;
import me.deecaad.core.mechanics.PlayerEffectMechanicList;
import me.deecaad.core.mechanics.Registry;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.targeters.ShapeTargeter;
import me.deecaad.core.mechanics.targeters.SourceTargeter;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.mechanics.targeters.WorldPlayersTargeter;
import me.deecaad.core.mechanics.targeters.WorldTargeter;
import me.deecaad.core.utils.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mechanics
implements Serializer<Mechanics> {
    public static final Registry<Mechanic> MECHANICS = new Registry("Mechanic");
    public static final Registry<Targeter> TARGETERS = new Registry("Targeter");
    public static final Registry<ShapeTargeter> SHAPES = new Registry("Shape");
    public static final Registry<Condition> CONDITIONS = new Registry("Condition");
    private List<Mechanic> mechanics;
    private List<Mechanic> dirty;

    public Mechanics() {
    }

    public Mechanics(List<Mechanic> mechanics) {
        this.mechanics = mechanics;
        this.dirty = new LinkedList<Mechanic>();
    }

    public List<Mechanic> getMechanics() {
        return this.mechanics;
    }

    public void addDirty(List<Mechanic> mechanics) {
        this.dirty.addAll(mechanics);
    }

    public boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    public void clearDirty() {
        this.dirty.clear();
    }

    @Override
    public String getKeyword() {
        return "Mechanics";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/";
    }

    public void use(CastData cast) {
        for (Mechanic mechanic : this.mechanics) {
            mechanic.use(cast);
        }
        for (Mechanic mechanic : this.dirty) {
            mechanic.use(cast);
        }
        this.clearDirty();
    }

    @Override
    @NotNull
    public Mechanics serialize(@NotNull SerializeData data) throws SerializerException {
        List<?> list = data.config.getList(data.key);
        ArrayList<Mechanic> mechanics = new ArrayList<Mechanic>();
        if (list == null) {
            throw data.exception(null, "Could not find any list... Are you still using the outdated Mechanics format?", "Need help? https://youtu.be/q8Oh2qsiCH0");
        }
        PlayerEffectMechanicList cacheList = new PlayerEffectMechanicList();
        for (Object obj : list) {
            PlayerEffectMechanic playerMechanic;
            Targeter targeter;
            Mechanic mechanic = this.serializeOne(data, obj.toString());
            if (mechanic instanceof PlayerEffectMechanic && (targeter = (playerMechanic = (PlayerEffectMechanic)mechanic).getViewerTargeter()) instanceof WorldTargeter) {
                WorldTargeter worldTargeter = (WorldTargeter)targeter;
                if (worldTargeter.isDefaultValues()) {
                    cacheList.addMechanic(playerMechanic);
                    continue;
                }
                playerMechanic.targeter = new WorldPlayersTargeter(worldTargeter.getWorldName());
                continue;
            }
            mechanics.add(mechanic);
        }
        if (!cacheList.isEmpty()) {
            mechanics.add(cacheList);
        }
        return new Mechanics(mechanics);
    }

    public Mechanic serializeOne(SerializeData data, String line) throws SerializerException {
        Pattern pattern = Pattern.compile(".+?(?=(?<!\\\\)(?:\\\\\\\\)*[?@]|$)");
        Matcher matcher = pattern.matcher(line);
        InlineSerializer mechanic = null;
        Targeter targeter = null;
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        while (matcher.find()) {
            int index = matcher.start();
            String group = matcher.group();
            try {
                switch (group.charAt(0)) {
                    case '@': {
                        if (targeter != null) {
                            throw data.exception(null, "Found multiple targeters with '@'", "Instead of using multiple targeters on the same line, try putting your mechanics on separate lines");
                        }
                        Matcher nameMatcher = InlineSerializer.NAME_FINDER.matcher(group);
                        if (!nameMatcher.find()) {
                            throw data.exception(null, "Could not determine the name of the targeter", "Make sure you included the {} after your targeter", SerializerException.forValue(group));
                        }
                        String temp = nameMatcher.group().substring(1);
                        targeter = TARGETERS.get(temp);
                        if (targeter == null) {
                            throw new SerializerOptionsException("Mechanics", "@Targeter", TARGETERS.getOptions(), temp, data.of().getLocation());
                        }
                        Map<String, MapConfigLike.Holder> args = InlineSerializer.inlineFormat(group.substring(1));
                        SerializeData nested = new SerializeData(targeter, data.file, null, (ConfigLike)new MapConfigLike(args).setDebugInfo(data.file, data.key, line));
                        targeter = (Targeter)targeter.serialize(nested);
                        break;
                    }
                    case '?': {
                        Matcher nameMatcher = InlineSerializer.NAME_FINDER.matcher(group);
                        if (!nameMatcher.find()) {
                            throw new InlineSerializer.FormatException(0, "Could not determine the name of the condition");
                        }
                        String temp = nameMatcher.group().substring(1);
                        Condition condition = CONDITIONS.get(temp);
                        if (condition == null) {
                            throw new SerializerOptionsException("Mechanics", "?Condition", CONDITIONS.getOptions(), temp, data.of().getLocation());
                        }
                        Map<String, MapConfigLike.Holder> args = InlineSerializer.inlineFormat(group.substring(1));
                        SerializeData nested = new SerializeData(condition, data.file, null, (ConfigLike)new MapConfigLike(args).setDebugInfo(data.file, data.key, line));
                        conditions.add((Condition)condition.serialize(nested));
                        break;
                    }
                    default: {
                        if (mechanic != null) {
                            throw data.exception(null, "Found multiple mechanics on the same line", "Mechanic 1: " + mechanic.getInlineKeyword(), "Mechanic 2: " + group, "If you are trying to use @targeters and ?conditions, make sure to use @ and ?");
                        }
                        Matcher nameMatcher = InlineSerializer.NAME_FINDER.matcher(group);
                        if (!nameMatcher.find()) {
                            throw data.exception(null, "Could not determine the name of the mechanic", "Make sure you included the {} after your mechanic!", SerializerException.forValue(group));
                        }
                        String temp = nameMatcher.group();
                        mechanic = MECHANICS.get(temp);
                        if (mechanic == null) {
                            throw new SerializerOptionsException("Mechanics", "Mechanic", MECHANICS.getOptions(), temp, data.of().getLocation());
                        }
                        Map<String, MapConfigLike.Holder> args = InlineSerializer.inlineFormat(group.substring(1));
                        SerializeData nested = new SerializeData(mechanic, data.file, null, (ConfigLike)new MapConfigLike(args).setDebugInfo(data.file, data.key, line));
                        mechanic = (Mechanic)mechanic.serialize(nested);
                    }
                }
                if (mechanic != null) continue;
                throw new InlineSerializer.FormatException(0, "Could not determine mechanic");
            }
            catch (InlineSerializer.FormatException ex) {
                String indent = "    ";
                throw data.exception(null, ex.getMessage(), indent + line, StringUtil.repeat(" ", index + ex.getIndex() + indent.length() - 1) + "^");
            }
        }
        if (targeter == null) {
            targeter = new SourceTargeter();
        }
        ((Mechanic)mechanic).targeter = targeter;
        ((Mechanic)mechanic).conditions = conditions;
        return mechanic;
    }
}

