/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.listeners;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.deecaad.core.compatibility.CompatibilityAPI;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class ItemCraftListener
implements Listener {
    private static final Set<String> craftingInventories = new HashSet<String>(Arrays.asList("ANVIL", "BEACON", "BLAST_FURNACE", "BREWING", "CARTOGRAPHY", "COMPOSTER", "CRAFTING", "ENCHANTING", "FURNACE", "GRINDSTONE", "LOOM", "MERCHANT", "SMITHING", "SMOKER", "STONECUTTER", "WORKBENCH"));

    @EventHandler
    public void click(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType == InventoryType.SlotType.OUTSIDE) {
            return;
        }
        ClickType clickType = event.getClick();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryView view = event.getView();
        Inventory playerInventory = view.getBottomInventory();
        InventoryType topInventoryType = view.getTopInventory().getType();
        if ((clickType.isShiftClick() || event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) && clickedInventory == playerInventory && this.isCraftingInventory(topInventoryType) && this.isDenyCraftingItem(event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        if (clickedInventory != playerInventory && this.isCraftingSlotType(slotType) && this.isDenyCraftingItem(event.getCursor())) {
            event.setCancelled(true);
            return;
        }
        int hotbarButton = event.getHotbarButton();
        if (clickedInventory != playerInventory && clickType == ClickType.NUMBER_KEY && this.isCraftingSlotType(slotType) && this.isDenyCraftingItem(playerInventory.getItem(hotbarButton))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        if (!this.isCraftingInventory(topInventory.getType())) {
            return;
        }
        if (!this.isDenyCraftingItem(event.getOldCursor())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot >= topInventory.getSize()) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void moveItem(InventoryMoveItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.isCraftingInventory(event.getDestination().getType()) && this.isDenyCraftingItem(event.getItem())) {
            event.setCancelled(true);
        }
    }

    private boolean isCraftingSlotType(InventoryType.SlotType slotType) {
        return slotType == InventoryType.SlotType.CRAFTING || slotType == InventoryType.SlotType.FUEL || slotType == InventoryType.SlotType.RESULT;
    }

    private boolean isCraftingInventory(InventoryType inventoryType) {
        return craftingInventories.contains(inventoryType.name());
    }

    private boolean isDenyCraftingItem(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        return CompatibilityAPI.getNBTCompatibility().getInt(itemStack, "MechanicsCore", "deny-crafting") == 1;
    }
}

