/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file.serializers;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.file.SerializerRangeException;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.SerializerUtil;
import me.deecaad.core.utils.StringUtil;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class ColorSerializer
implements InlineSerializer<ColorSerializer> {
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]{6}");
    private Color color;

    public ColorSerializer() {
    }

    public ColorSerializer(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public ColorSerializer serialize(@NotNull SerializeData data) throws SerializerException {
        String input = data.config.getString(data.key);
        if (input == null || input.isEmpty()) {
            throw new SerializerMissingKeyException(this, "Color", SerializerUtil.foundAt(data.file, data.key));
        }
        Color color = ColorSerializer.fromString(data, input.trim());
        return new ColorSerializer(color);
    }

    public static Color fromString(SerializeData data, String input) throws SerializerException {
        if (input.startsWith("0x")) {
            String substring = input.substring(2);
            if (substring.length() != 6) {
                throw data.exception(null, "Hex strings should have 6 digits", SerializerException.forValue(input), SerializerException.examples("0xFF00BB", "0x123456", "0x111111"));
            }
            int rgb = Integer.parseInt(substring, 16);
            return Color.fromRGB((int)rgb);
        }
        if (input.startsWith("#")) {
            String substring = input.substring(1);
            if (substring.length() != 6) {
                throw data.exception(null, "Hex strings should have 6 digits", SerializerException.forValue(input), SerializerException.examples("#FF00BB", "#123456", "#111111"));
            }
            int rgb = Integer.parseInt(substring, 16);
            return Color.fromRGB((int)rgb);
        }
        if (HEX_PATTERN.matcher(input).find()) {
            Matcher matcher = HEX_PATTERN.matcher(input);
            matcher.find();
            String substring = matcher.group();
            int rgb = Integer.parseInt(substring, 16);
            return Color.fromRGB((int)rgb);
        }
        if (StringUtil.split(input).size() == 3) {
            String[] split = input.split("-");
            int r = Integer.parseInt(split[0]);
            int g = Integer.parseInt(split[1]);
            int b = Integer.parseInt(split[2]);
            if (r < 0 || r > 255) {
                throw new SerializerRangeException("Color", 0, r, 255, SerializerUtil.foundAt(data.file, data.key));
            }
            if (g < 0 || g > 255) {
                throw new SerializerRangeException("Color", 0, g, 255, SerializerUtil.foundAt(data.file, data.key));
            }
            if (b < 0 || b > 255) {
                throw new SerializerRangeException("Color", 0, b, 255, SerializerUtil.foundAt(data.file, data.key));
            }
            return Color.fromRGB((int)r, (int)g, (int)b);
        }
        Optional<ColorType> optional = EnumUtil.getIfPresent(ColorType.class, input.toUpperCase(Locale.ROOT));
        if (optional.isPresent()) {
            return optional.get().color;
        }
        throw data.exception(null, SerializerException.forValue(input), SerializerException.didYouMean(input, ColorType.class), "Choose one of these formats: #RRGGBB, r g b, RED, RRGGBB, 0xRRGGBB, r~g~b", SerializerException.examples("#AA0022", "255 100 0", "RED", "444411", "BLUE", "0 0 255"));
    }

    public static enum ColorType {
        BLACK(Color.fromRGB((int)0, (int)0, (int)0)),
        DARK_BLUE(Color.fromRGB((int)0, (int)0, (int)170)),
        DARK_GREEN(Color.fromRGB((int)0, (int)170, (int)0)),
        DARK_AQUA(Color.fromRGB((int)0, (int)170, (int)170)),
        DARK_RED(Color.fromRGB((int)170, (int)0, (int)0)),
        DARK_PURPLE(Color.fromRGB((int)170, (int)0, (int)170)),
        GOLD(Color.fromRGB((int)255, (int)170, (int)0)),
        GRAY(Color.fromRGB((int)170, (int)170, (int)170)),
        DARK_GRAY(Color.fromRGB((int)85, (int)85, (int)85)),
        BLUE(Color.fromRGB((int)85, (int)85, (int)255)),
        GREEN(Color.fromRGB((int)85, (int)255, (int)85)),
        AQUA(Color.fromRGB((int)85, (int)255, (int)255)),
        RED(Color.fromRGB((int)255, (int)85, (int)85)),
        LIGHT_PURPLE(Color.fromRGB((int)255, (int)85, (int)255)),
        YELLOW(Color.fromRGB((int)255, (int)255, (int)85)),
        WHITE(Color.fromRGB((int)255, (int)255, (int)255));

        private final Color color;

        private ColorType(Color color) {
            this.color = color;
        }

        public Color getBukkitColor() {
            return this.color;
        }

        public static Color fromString(String colorString) {
            List<String> splittedColor = StringUtil.split(colorString);
            if (splittedColor.size() == 1) {
                try {
                    return ColorType.valueOf(colorString).getBukkitColor();
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return ColorType.fromRGBString(splittedColor);
        }

        public static Color fromRGBString(List<String> splittedColor) {
            if (splittedColor.size() < 3) {
                MechanicsCore.debug.log(LogLevel.ERROR, "Tried to get RGB color out of " + String.valueOf(splittedColor) + ", but it wasn't in correct format.", "Correct format is red-green-blue");
                return null;
            }
            try {
                int red = Integer.parseInt(splittedColor.get(0));
                int green = Integer.parseInt(splittedColor.get(1));
                int blue = Integer.parseInt(splittedColor.get(2));
                return Color.fromRGB((int)red, (int)green, (int)blue);
            }
            catch (NumberFormatException e) {
                MechanicsCore.debug.log(LogLevel.ERROR, "Tried to get RGB color out of " + String.valueOf(splittedColor) + ", but it didn't contain integers.");
                return null;
            }
        }

        public static float getAsParticleColor(float value) {
            if (value < 1.0f) {
                value = 1.0f;
            }
            return value / 255.0f;
        }
    }
}

