/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file.serializers;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerRangeException;
import me.deecaad.core.file.SerializerTypeException;
import org.jetbrains.annotations.NotNull;

public class ChanceSerializer
implements Serializer<Double> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Double serialize(@NotNull SerializeData data) throws SerializerException {
        Object value = data.of().assertExists().get();
        double chance = 0.0;
        if (value.toString().contains("%")) {
            String str = value.toString().trim();
            if (str.startsWith("%")) {
                chance = Double.parseDouble(str.substring(1)) / 100.0;
            } else {
                if (!str.endsWith("%")) throw data.exception(null, "Chance input had a '%' in the middle when it should have been on the end", SerializerException.forValue(value));
                chance = Double.parseDouble(str.substring(0, str.length() - 1)) / 100.0;
            }
        } else {
            if (!(value instanceof Number)) throw new SerializerTypeException(data.serializer, Number.class, value.getClass(), value, data.of().getLocation());
            chance = ((Number)value).doubleValue();
        }
        if (!(chance < 0.0) && !(chance > 1.0)) return chance;
        throw new SerializerRangeException(data.serializer, 0.0, chance, 1.0, data.of().getLocation()).addMessage("When using percentages, make sure to stay between 0% and 100%");
    }
}

