/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import org.jetbrains.annotations.NotNull;

public class SerializerRangeException
extends SerializerException {
    public SerializerRangeException(@NotNull String name, int min, int actual, int max, @NotNull String location) {
        super(name, SerializerRangeException.getMessages(min, actual, max), location);
    }

    public SerializerRangeException(@NotNull Serializer<?> serializer, int min, int actual, int max, @NotNull String location) {
        super(serializer, SerializerRangeException.getMessages(min, actual, max), location);
    }

    public SerializerRangeException(@NotNull String name, double min, double actual, double max, @NotNull String location) {
        super(name, SerializerRangeException.getMessages(min, actual, max), location);
    }

    public SerializerRangeException(@NotNull Serializer<?> serializer, double min, double actual, double max, @NotNull String location) {
        super(serializer, SerializerRangeException.getMessages(min, actual, max), location);
    }

    private static String[] getMessages(int min, int actual, int max) {
        return new String[]{"Given integer needs to be between " + min + " and " + max, SerializerRangeException.forValue(actual)};
    }

    private static String[] getMessages(double min, double actual, double max) {
        return new String[]{"Given integer needs to be between " + min + " and " + max, SerializerRangeException.forValue(actual)};
    }
}

