/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.utils.Debugger;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.StringUtil;
import org.jetbrains.annotations.NotNull;

public class SerializerException
extends Exception {
    private String serializerName;
    private String[] messages;
    private String location;

    public SerializerException(String serializerName, String[] messages, String location) {
        this.serializerName = serializerName;
        this.messages = messages;
        this.location = location;
    }

    public SerializerException(@NotNull Serializer<?> serializer, String[] messages, @NotNull String location) {
        this.messages = messages;
        this.location = location;
        this.serializerName = serializer.getName();
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }

    public String[] getMessages() {
        return (String[])this.messages.clone();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void log(Debugger debug) {
        this.log(debug, LogLevel.ERROR);
    }

    public void log(Debugger debug, LogLevel level) {
        LinkedList<Object> collected = new LinkedList<Object>();
        collected.add("A mistake was found in your configurations when making '" + this.serializerName + "'");
        collected.addAll(Arrays.asList(this.messages));
        collected.add(this.location);
        collected.add("");
        debug.log(level, collected.toArray(new String[0]));
    }

    public SerializerException addMessage(boolean condition, String message) {
        if (condition) {
            this.addMessage(message);
        }
        return this;
    }

    public SerializerException addMessage(String message) {
        String[] copy = new String[this.messages.length + 1];
        System.arraycopy(this.messages, 0, copy, 0, this.messages.length);
        copy[this.messages.length] = message;
        this.messages = copy;
        return this;
    }

    public static String forValue(Object value) {
        return "Found value: " + String.valueOf(value);
    }

    public static <T extends Enum<T>> String didYouMean(String input, Class<T> enumClass) {
        return SerializerException.didYouMean(input, EnumUtil.getOptions(enumClass));
    }

    public static String didYouMean(String input, Iterable<String> options) {
        String expected = StringUtil.didYouMean(input, options);
        return "Did you mean to use '" + expected + "' instead of '" + input + "'?";
    }

    public static String examples(String ... examples) {
        StringBuilder builder = new StringBuilder("'");
        for (String str : examples) {
            builder.append(str).append("', ");
        }
        builder.setLength(builder.length() - 2);
        return "Example values: " + String.valueOf(builder);
    }

    public static String possibleValues(Iterable<String> options, String actual, int count) {
        ArrayList arr = new ArrayList();
        options.forEach(arr::add);
        int[] table = StringUtil.toCharTable(actual);
        arr.sort((a, b) -> {
            int[] localA = StringUtil.toCharTable(a);
            int[] localB = StringUtil.toCharTable(b);
            int differenceA = Math.abs(actual.length() - a.length());
            int differenceB = Math.abs(actual.length() - b.length());
            for (int i = 0; i < table.length; ++i) {
                differenceA += Math.abs(table[i] - localA[i]);
                differenceB += Math.abs(table[i] - localB[i]);
            }
            return Integer.compare(differenceA, differenceB);
        });
        count = Math.min(arr.size(), count);
        StringBuilder builder = new StringBuilder("Showing ");
        if (count == arr.size()) {
            builder.append("All");
        } else {
            builder.append(count).append('/').append(arr.size());
        }
        builder.append(" Options:");
        Iterator iterator = arr.iterator();
        while (iterator.hasNext() && count-- > 0) {
            String next = (String)iterator.next();
            builder.append(" '").append(next).append("'");
        }
        return builder.toString();
    }
}

