/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.XParticle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.deecaad.core.file.BukkitConfig;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.MapConfigLike;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerEnumException;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.file.SerializerNegativeException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.file.SerializerPathToException;
import me.deecaad.core.file.SerializerRangeException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.SerializerUtil;
import me.deecaad.core.utils.StringUtil;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializeData {
    public final String serializer;
    public final File file;
    public final String key;
    public final ConfigLike config;
    @Nullable
    public String wikiLink;
    public Configuration pathToConfig;
    private boolean usingStep;

    public SerializeData(@NotNull String serializer, @NotNull File file, String key, @NotNull ConfigLike config) {
        this.serializer = serializer;
        this.file = file;
        this.key = key;
        this.config = config;
    }

    public SerializeData(@NotNull String serializer, @NotNull SerializeData other, @NotNull String relative) {
        this.serializer = serializer;
        this.file = other.file;
        this.key = other.getPath(relative);
        this.config = other.config;
        this.copyMutables(other);
    }

    public SerializeData(@NotNull Serializer<?> serializer, @NotNull File file, String key, @NotNull ConfigLike config) {
        this.serializer = SerializeData.getSimpleName(serializer);
        this.file = file;
        this.key = key;
        this.config = config;
        this.wikiLink = serializer.getWikiLink();
    }

    public SerializeData(@NotNull Serializer<?> serializer, @NotNull SerializeData other, @NotNull String relative) {
        this.serializer = SerializeData.getSimpleName(serializer);
        this.file = other.file;
        this.key = other.getPath(relative);
        this.config = other.config;
        this.copyMutables(other);
        this.wikiLink = serializer.getWikiLink();
    }

    @NotNull
    private SerializeData copyMutables(@NotNull SerializeData from) {
        this.wikiLink = from.wikiLink;
        this.usingStep = from.usingStep;
        return this;
    }

    @NotNull
    private static String getSimpleName(@NotNull Serializer<?> serializer) {
        return serializer.getName();
    }

    private String getPath(String relative) {
        return this.key == null || this.key.isEmpty() ? relative : this.key + "." + relative;
    }

    @NotNull
    public SerializeData move(@NotNull String relative) {
        return new SerializeData(this.serializer, this, relative).copyMutables(this);
    }

    @NotNull
    public <T extends Serializer<T>> SerializeData step(@NotNull Class<T> serializer) throws SerializerException {
        return this.step((Serializer)ReflectionUtil.newInstance(serializer));
    }

    @NotNull
    public SerializeData step(@NotNull Serializer<?> serializer) throws SerializerException {
        if (serializer.getKeyword() == null || !serializer.canUsePathTo()) {
            throw new IllegalArgumentException(String.valueOf(serializer) + " does not support path-to");
        }
        String relative = serializer.getKeyword();
        if (this.config instanceof BukkitConfig && this.config.isString(this.getPath(relative))) {
            if (this.pathToConfig == null) {
                throw new SerializerPathToException(serializer, this);
            }
            String path = this.config.getString(this.getPath(relative));
            SerializeData temp = new SerializeData(serializer, this.file, path, this.config);
            temp.copyMutables(this);
            temp.usingStep = true;
            return temp;
        }
        return this.move(relative);
    }

    @NotNull
    public ConfigListAccessor ofList() {
        String[] split = this.key.split("\\.");
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            key.append(split[i]).append('.');
        }
        if (!key.isEmpty()) {
            key.setLength(key.length() - 1);
        }
        return new SerializeData(this.serializer, this.file, key.toString(), this.config).copyMutables(this).ofList(split[split.length - 1]);
    }

    public ConfigAccessor of() {
        String[] split = this.key.split("\\.");
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            key.append(split[i]).append('.');
        }
        if (!key.isEmpty()) {
            key.setLength(key.length() - 1);
        }
        return new SerializeData(this.serializer, this.file, key.toString(), this.config).copyMutables(this).of(split[split.length - 1]);
    }

    @NotNull
    public ConfigAccessor of(@NotNull String relative) {
        return new ConfigAccessor(relative);
    }

    public ConfigListAccessor ofList(String relative) {
        return new ConfigListAccessor(relative);
    }

    public boolean has(String relative) {
        return this.usingStep ? this.pathToConfig.containsKey(this.getPath(relative)) : this.config.contains(this.getPath(relative));
    }

    @NotNull
    public SerializerException exception(@Nullable String relative, String ... messages) {
        if (messages.length == 0) {
            throw new IllegalArgumentException("Hey you! Yeah you! Don't be lazy, add messages!");
        }
        String key = this.key;
        if (relative != null && !relative.isEmpty()) {
            key = this.getPath(relative);
        }
        return new SerializerException(this.serializer, this.appendWikiLink(messages), SerializerUtil.foundAt(this.file, key));
    }

    @NotNull
    public SerializerException listException(@Nullable String relative, int index, String ... messages) {
        if (messages.length == 0) {
            throw new IllegalArgumentException("Hey you! Yeah you! Don't be lazy, add messages!");
        }
        String key = this.key;
        if (relative != null && !relative.isEmpty()) {
            key = this.getPath(relative);
        }
        return new SerializerException(this.serializer, this.appendWikiLink(messages), SerializerUtil.foundAt(this.file, key, index + 1));
    }

    @NotNull
    private String[] appendWikiLink(@NotNull String[] messages) {
        if (this.wikiLink == null || Arrays.stream(messages).anyMatch(str -> str.startsWith("Wiki: "))) {
            return messages;
        }
        String[] copy = new String[messages.length + 1];
        System.arraycopy(messages, 0, copy, 0, messages.length);
        copy[messages.length] = this.getWikiMessage();
        return copy;
    }

    @NotNull
    private String getWikiMessage() {
        return "Wiki: " + this.wikiLink;
    }

    public class ConfigListAccessor {
        private final LinkedList<ClassArgument> arguments = new LinkedList();
        private final String relative;
        private boolean didAssertions;

        public ConfigListAccessor(String relative) {
            this.relative = relative;
        }

        @NotNull
        public ConfigListAccessor addArgument(Class<?> clazz, boolean required) {
            return this.addArgument(clazz, required, false);
        }

        @NotNull
        public ConfigListAccessor addArgument(Class<?> clazz, boolean required, boolean skipCheck) {
            if (required && !this.arguments.isEmpty() && !this.arguments.getLast().required) {
                throw new IllegalArgumentException("Required arguments must be consecutive");
            }
            ClassArgument arg = new ClassArgument();
            arg.clazz = clazz;
            arg.required = required;
            arg.skipCheck = skipCheck;
            this.arguments.add(arg);
            return this;
        }

        @NotNull
        public ConfigListAccessor assertArgumentPositive() {
            this.arguments.getLast().positive = true;
            return this;
        }

        @NotNull
        public ConfigListAccessor assertArgumentRange(double min, double max) {
            this.arguments.getLast().min = min;
            this.arguments.getLast().max = max;
            return this;
        }

        @NotNull
        public ConfigListAccessor assertExists() throws SerializerException {
            if (!SerializeData.this.has(this.relative)) {
                throw new SerializerMissingKeyException(SerializeData.this.serializer, this.relative, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return this;
        }

        @NotNull
        public ConfigListAccessor assertExists(boolean exists) throws SerializerException {
            if (exists) {
                return this.assertExists();
            }
            return this;
        }

        @NotNull
        public ConfigListAccessor assertList() throws SerializerException {
            Object value;
            if (this.arguments.isEmpty()) {
                throw new IllegalStateException("Need to set arguments before assertions");
            }
            this.didAssertions = true;
            Object object = value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            if (value == null) {
                return this;
            }
            if (!(value instanceof List)) {
                throw new SerializerTypeException(SerializeData.this.serializer, List.class, value.getClass(), value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            List list = (List)value;
            if (list.isEmpty()) {
                return this;
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = Objects.toString(list.get(i));
                StringBuilder format = new StringBuilder("<");
                this.arguments.forEach(arg -> {
                    format.append(arg.clazz.getSimpleName());
                    if (arg.required) {
                        format.append('*');
                    }
                    format.append("> <");
                });
                format.append('>');
                if (string == null || string.trim().isEmpty()) {
                    throw SerializeData.this.listException(this.relative, i, this.relative + " does not allow empty elements in the list.", "Valid Format: " + String.valueOf(format));
                }
                List<String> split = StringUtil.split(string);
                int required = (int)this.arguments.stream().filter(arg -> arg.required).count();
                if (split.size() < required) {
                    throw SerializeData.this.listException(this.relative, i, this.relative + " requires the first " + required + " arguments to be defined.", SerializerException.forValue(string), "You are missing " + (required - split.size()) + " arguments", "Valid Format: " + String.valueOf(format));
                }
                for (int j = 0; j < split.size(); ++j) {
                    if (this.arguments.size() <= j) {
                        throw SerializeData.this.listException(this.relative, i, "Invalid list format, " + this.relative + " can only use " + this.arguments.size() + " arguments.", SerializerException.forValue(string), "Valid Format: " + String.valueOf(format));
                    }
                    String component = split.get(j);
                    ClassArgument argument = this.arguments.get(j);
                    if (argument.skipCheck) continue;
                    try {
                        if (argument.clazz == Integer.TYPE || argument.clazz == Integer.class) {
                            argument.clazz = Integer.class;
                            int parseInt = Integer.parseInt(component);
                            if (!Double.isNaN(argument.min) && !Double.isNaN(argument.max) && ((double)parseInt < argument.min || (double)parseInt > argument.max)) {
                                throw new SerializerRangeException(SerializeData.this.serializer, (int)argument.min, parseInt, (int)argument.max, this.getLocation(i));
                            }
                            if (!argument.positive || parseInt >= 0) continue;
                            throw new SerializerNegativeException(SerializeData.this.serializer, (Object)parseInt, this.getLocation(i));
                        }
                        if (argument.clazz == Double.TYPE || argument.clazz == Double.class) {
                            argument.clazz = Double.class;
                            double parseDouble = Double.parseDouble(component);
                            if (!Double.isNaN(argument.min) && !Double.isNaN(argument.max) && (parseDouble < argument.min || parseDouble > argument.max)) {
                                throw new SerializerRangeException(SerializeData.this.serializer, argument.min, parseDouble, argument.max, this.getLocation(i));
                            }
                            if (!argument.positive || !(parseDouble < 0.0)) continue;
                            throw new SerializerNegativeException(SerializeData.this.serializer, (Object)parseDouble, this.getLocation(i));
                        }
                        if (argument.clazz == Boolean.TYPE || argument.clazz == Boolean.class) {
                            argument.clazz = Boolean.class;
                            if (component.equalsIgnoreCase("true") || component.equalsIgnoreCase("false")) continue;
                            throw new Exception();
                        }
                        if (!argument.clazz.isEnum() || !EnumUtil.parseEnums(argument.clazz, component).isEmpty()) continue;
                        throw new SerializerEnumException(SerializeData.this.serializer, argument.clazz, component, true, this.getLocation(i));
                    }
                    catch (SerializerException ex) {
                        throw ex.addMessage("Full List Element: " + string).addMessage("Valid List Format: " + String.valueOf(format)).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
                    }
                    catch (Exception ex) {
                        throw new SerializerTypeException(SerializeData.this.serializer, argument.clazz, null, (Object)component, this.getLocation(i)).addMessage("Full List Element: " + string).addMessage("Valid List Format: " + String.valueOf(format)).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
                    }
                }
            }
            return this;
        }

        public List<String[]> get() {
            if (!this.didAssertions) {
                throw new IllegalStateException("Forgot to call assertList()? Did something go wrong?");
            }
            if (!SerializeData.this.has(this.relative)) {
                return Collections.emptyList();
            }
            ArrayList<String[]> list = new ArrayList<String[]>();
            List<String> configList = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getList(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getList(SerializeData.this.getPath(this.relative));
            for (String obj : configList) {
                list.add(StringUtil.split(obj.toString()).toArray(new String[0]));
            }
            return list;
        }

        public Stream<String[]> stream() {
            return this.get().stream();
        }

        public String getLocation() {
            String stepAddon;
            String string = stepAddon = SerializeData.this.usingStep ? " (File location will be inaccurate since you are using path-to)" : "";
            if (this.relative == null || this.relative.isEmpty()) {
                return SerializeData.this.config.getLocation(SerializeData.this.file, SerializeData.this.key) + stepAddon;
            }
            return SerializeData.this.config.getLocation(SerializeData.this.file, SerializeData.this.getPath(this.relative)) + stepAddon;
        }

        public String getLocation(int index) {
            String stepAddon;
            String string = stepAddon = SerializeData.this.usingStep ? " (File location will be inaccurate since you are using path-to)" : "";
            if (this.relative == null || this.relative.isEmpty()) {
                return SerializerUtil.foundAt(SerializeData.this.file, SerializeData.this.key, index + 1) + stepAddon;
            }
            return SerializerUtil.foundAt(SerializeData.this.file, SerializeData.this.getPath(this.relative), index + 1) + stepAddon;
        }

        private static class ClassArgument {
            Class<?> clazz;
            boolean required;
            boolean skipCheck;
            boolean positive;
            double min = Double.NaN;
            double max = Double.NaN;

            private ClassArgument() {
            }
        }
    }

    public class ConfigAccessor {
        protected final String relative;
        private boolean exists;

        private ConfigAccessor(String relative) {
            this.relative = relative;
        }

        @NotNull
        public ConfigAccessor assertExists() throws SerializerException {
            if (!SerializeData.this.has(this.relative)) {
                throw new SerializerMissingKeyException(SerializeData.this.serializer, this.relative, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            this.exists = true;
            return this;
        }

        @NotNull
        public ConfigAccessor assertExists(boolean exists) throws SerializerException {
            if (exists) {
                return this.assertExists();
            }
            return this;
        }

        public boolean is(@NotNull Class<?> type) {
            if (type == Integer.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Character.TYPE || type == Byte.TYPE) {
                throw new IllegalArgumentException("Silly developer, these are primitive types! Check wrapper classes instead.");
            }
            Object value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            return value != null && type.isAssignableFrom(value.getClass());
        }

        @NotNull
        public ConfigAccessor assertType(@NotNull Class<?> type) throws SerializerException {
            Class<?> actual;
            Object value;
            Object object = value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            if (value != null && !type.isAssignableFrom(actual = value.getClass())) {
                throw new SerializerTypeException(SerializeData.this.serializer, type, actual, value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return this;
        }

        public int getInt() throws SerializerException {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getInt(Integer.MIN_VALUE);
        }

        public int getInt(int def) throws SerializerException {
            Number num = Objects.requireNonNull(this.getNumber(def));
            if (Double.compare(Math.floor(num.doubleValue()), Math.ceil(num.doubleValue())) != 0) {
                throw new SerializerTypeException(SerializeData.this.serializer, Integer.class, Double.class, (Object)num, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return num.intValue();
        }

        public double getDouble() throws SerializerException {
            if (!this.exists) {
                throw new IllegalArgumentException("Either provide a default value or use assertExists()!");
            }
            return this.getDouble(Double.NaN);
        }

        public double getDouble(double def) throws SerializerException {
            return Objects.requireNonNull(this.getNumber(def)).doubleValue();
        }

        public boolean getBool() throws SerializerException {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getBool(false);
        }

        public boolean getBool(boolean def) throws SerializerException {
            Object value;
            Object object = value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            if (value == null) {
                return def;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                if (value.toString().trim().equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.toString().trim().equalsIgnoreCase("false")) {
                    return false;
                }
            }
            throw new SerializerTypeException(SerializeData.this.serializer, Boolean.class, value.getClass(), value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
        }

        @Nullable
        public Number getNumber(@Nullable Number def) throws SerializerException {
            Object value;
            Object object = value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            if (value == null) {
                return def;
            }
            if (value instanceof String) {
                String str = (String)value;
                try {
                    value = Double.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    throw new SerializerTypeException(SerializeData.this.serializer, Number.class, value.getClass(), value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
                }
            }
            try {
                return (Number)value;
            }
            catch (ClassCastException ex) {
                throw new SerializerTypeException(SerializeData.this.serializer, Number.class, value.getClass(), value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
        }

        @NotNull
        public ConfigAccessor assertPositive() throws SerializerException {
            Number value = this.getNumber(null);
            if (value != null && (value instanceof Long && value.longValue() < 0L || value.doubleValue() < 0.0)) {
                throw new SerializerNegativeException(SerializeData.this.serializer, (Object)value, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return this;
        }

        @NotNull
        public ConfigAccessor assertRange(int min, int max) throws SerializerException {
            int num;
            if (min > max) {
                throw new IllegalArgumentException("min > max");
            }
            Number value = this.getNumber(null);
            if (value != null && ((num = value.intValue()) < min || num > max)) {
                throw new SerializerRangeException(SerializeData.this.serializer, min, num, max, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return this;
        }

        @NotNull
        public ConfigAccessor assertRange(double min, double max) throws SerializerException {
            double num;
            if (min > max) {
                throw new IllegalArgumentException("min > max");
            }
            Number value = this.getNumber(null);
            if (value != null && ((num = value.doubleValue()) < min || num > max)) {
                throw new SerializerRangeException(SerializeData.this.serializer, min, num, max, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return this;
        }

        @NotNull
        public String getLocation() {
            String stepAddon;
            String string = stepAddon = SerializeData.this.usingStep ? " (File location will be inaccurate since you are using path-to)" : "";
            if (this.relative == null || this.relative.isEmpty()) {
                return SerializeData.this.config.getLocation(SerializeData.this.file, SerializeData.this.key) + stepAddon;
            }
            return SerializeData.this.config.getLocation(SerializeData.this.file, SerializeData.this.getPath(this.relative)) + stepAddon;
        }

        @NotNull
        public <T> T get() {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return (T)(SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative)));
        }

        @Nullable
        public <T> T get(T defaultValue) {
            return (T)(SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative), defaultValue) : SerializeData.this.config.get(SerializeData.this.getPath(this.relative), defaultValue));
        }

        @Nullable
        public <T extends Enum<T>> T getEnum(@NotNull Class<T> clazz) throws SerializerException {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getEnum(clazz, null);
        }

        @Nullable
        public <T extends Enum<T>> T getEnum(@NotNull Class<T> clazz, @Nullable T defaultValue) throws SerializerException {
            String input;
            String string = input = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
            if (input == null || input.isBlank()) {
                return defaultValue;
            }
            if ((input = input.trim()).startsWith("$")) {
                throw new SerializerEnumException(SerializeData.this.serializer, clazz, input, false, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            List<T> list = EnumUtil.parseEnums(clazz, input);
            if (list.isEmpty()) {
                throw new SerializerEnumException(SerializeData.this.serializer, clazz, input, false, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return (T)((Enum)list.get(0));
        }

        @Nullable
        public XMaterial getMaterial(@Nullable XMaterial defaultValue) throws SerializerException {
            String input;
            String string = input = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
            if (input == null || input.isBlank()) {
                return defaultValue;
            }
            Optional xmat = XMaterial.matchXMaterial((String)(input = input.trim()));
            if (xmat.isEmpty()) {
                throw new SerializerEnumException(SerializeData.this.serializer, Material.class, input, false, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return (XMaterial)xmat.get();
        }

        @Nullable
        public ItemStack getMaterialAsItem(@Nullable ItemStack defaultValue) throws SerializerException {
            XMaterial xmat = this.getMaterial(null);
            if (xmat == null) {
                return defaultValue;
            }
            return xmat.parseItem();
        }

        @Nullable
        public EntityType getEntityType(@Nullable EntityType defaultValue) throws SerializerException {
            String input;
            String string = input = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
            if (input == null || input.isBlank()) {
                return defaultValue;
            }
            XEntityType entityType = XEntityType.of((String)(input = input.trim()));
            if (entityType == null) {
                throw new SerializerEnumException(SerializeData.this.serializer, EntityType.class, input, false, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return entityType.get();
        }

        @Nullable
        public Particle getParticle(@Nullable Particle defaultValue) throws SerializerException {
            String input;
            String string = input = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
            if (input == null || input.isBlank()) {
                return defaultValue;
            }
            XParticle particle = XParticle.of((String)(input = input.trim()));
            if (particle == null) {
                throw new SerializerEnumException(SerializeData.this.serializer, Particle.class, input, false, this.getLocation()).addMessage(SerializeData.this.wikiLink != null, SerializeData.this.getWikiMessage());
            }
            return particle.get();
        }

        @Nullable
        public <T extends Keyed> T getKeyed(@NotNull Registry<T> registry) throws SerializerException {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getKeyed(registry, null);
        }

        @Nullable
        public <T extends Keyed> T getKeyed(@NotNull Registry<T> registry, @Nullable T defaultValue) throws SerializerException {
            Object value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getObject(SerializeData.this.getPath(this.relative), "") : SerializeData.this.config.get(SerializeData.this.getPath(this.relative), "");
            String input = value.toString().trim().toLowerCase(Locale.ROOT);
            if (input.isEmpty()) {
                return defaultValue;
            }
            NamespacedKey key = null;
            LinkedHashSet<String> options = new LinkedHashSet<String>();
            String registryName = "Registry";
            for (Keyed element : registry) {
                key = element.getKey();
                registryName = element.getClass().getSimpleName();
                options.add(key.toString());
                if ("minecraft".equals(key.getNamespace())) {
                    options.add(key.getKey());
                }
                if (input.equals(key.toString()) || "minecraft".equals(key.getNamespace()) && input.equals(key.getKey())) break;
                key = null;
            }
            if (key == null) {
                throw new SerializerOptionsException(SerializeData.this.serializer, registryName, options, value.toString(), this.getLocation());
            }
            Keyed returnValue = registry.get(key);
            if (returnValue == null) {
                throw new RuntimeException("This should never occur");
            }
            return (T)returnValue;
        }

        @Nullable
        public String getAdventure() {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getAdventure(null);
        }

        @Nullable
        public String getAdventure(@Nullable String defaultValue) {
            String value;
            if (!SerializeData.this.has(this.relative)) {
                return defaultValue;
            }
            String string = value = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) : SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
            assert (value != null);
            return StringUtil.colorAdventure(value);
        }

        @Nullable
        public <T extends InlineSerializer<T>> T getRegistry(me.deecaad.core.mechanics.Registry<T> registry) throws SerializerException {
            if (!this.exists) {
                throw new IllegalStateException("Either provide a default value or use assertExists()!");
            }
            return this.getRegistry(registry, null);
        }

        @Nullable
        public <T extends InlineSerializer<T>> T getRegistry(@NotNull me.deecaad.core.mechanics.Registry<T> registry, @Nullable T defaultValue) throws SerializerException {
            ConfigLike configLike = SerializeData.this.config;
            if (!(configLike instanceof MapConfigLike)) {
                throw new UnsupportedOperationException("Cannot use registries with " + String.valueOf(SerializeData.this.config));
            }
            MapConfigLike mapLike = (MapConfigLike)configLike;
            if (!SerializeData.this.has(this.relative)) {
                return defaultValue;
            }
            Map map = (Map)this.assertType(Map.class).assertExists().get();
            MapConfigLike temp = new MapConfigLike(map).setDebugInfo(mapLike.getFile(), mapLike.getPath(), mapLike.getFullLine());
            SerializeData nested = new SerializeData(SerializeData.this.serializer, SerializeData.this.file, null, (ConfigLike)temp);
            String key = (String)nested.of("uniqueIdentifier").assertExists().assertType(String.class).get();
            InlineSerializer base = (InlineSerializer)registry.get(key);
            if (base == null) {
                throw new SerializerOptionsException(SerializeData.this.serializer, registry.getKey(), registry.getOptions(), key, this.getLocation());
            }
            return (T)((InlineSerializer)base.serialize(nested));
        }

        @Nullable
        public <SerializerType extends Serializer<SerializedType>, SerializedType> SerializedType getImplied(@NotNull SerializerType impliedType) throws SerializerException {
            ConfigLike configLike = SerializeData.this.config;
            if (!(configLike instanceof MapConfigLike)) {
                throw new UnsupportedOperationException("Cannot use registries with " + String.valueOf(SerializeData.this.config));
            }
            MapConfigLike mapLike = (MapConfigLike)configLike;
            if (!SerializeData.this.has(this.relative)) {
                return null;
            }
            Map map = (Map)SerializeData.this.config.get(SerializeData.this.getPath(this.relative));
            if (map.containsKey("uniqueIdentifier") && !me.deecaad.core.mechanics.Registry.matches(map.get("uniqueIdentifier").toString(), impliedType.getKeyword())) {
                throw SerializeData.this.exception(this.relative, "Expected a '" + impliedType.getKeyword() + "' but got a '" + String.valueOf(map.get("uniqueIdentifier")) + "'");
            }
            MapConfigLike temp = new MapConfigLike(map).setDebugInfo(mapLike.getFile(), mapLike.getPath(), mapLike.getFullLine());
            SerializeData nested = new SerializeData(impliedType, SerializeData.this.file, null, (ConfigLike)temp);
            return impliedType.serialize(nested);
        }

        @NotNull
        public <T extends InlineSerializer<T>> List<T> getRegistryList(@NotNull me.deecaad.core.mechanics.Registry<T> registry) throws SerializerException {
            ConfigLike configLike = SerializeData.this.config;
            if (!(configLike instanceof MapConfigLike)) {
                throw new UnsupportedOperationException("Cannot use registries with " + String.valueOf(SerializeData.this.config));
            }
            MapConfigLike mapLike = (MapConfigLike)configLike;
            if (!SerializeData.this.has(this.relative)) {
                return List.of();
            }
            List<?> list = SerializeData.this.config.getList(SerializeData.this.getPath(this.relative));
            ArrayList<InlineSerializer> returnValue = new ArrayList<InlineSerializer>();
            for (int i = 0; i < list.size(); ++i) {
                MapConfigLike.Holder holder = (MapConfigLike.Holder)list.get(i);
                Object object = holder.value();
                if (!(object instanceof Map)) {
                    throw SerializeData.this.listException(this.relative, i, "Expected an inline serializer like 'sound(sound=ENTITY_GENERIC_EXPLOSION)', but instead got '" + String.valueOf(holder.value()) + "'");
                }
                Map map = (Map)object;
                if (!map.containsKey("uniqueIdentifier")) {
                    throw SerializeData.this.listException(this.relative, i, "Missing name for a(n) '" + SerializeData.this.serializer + "'");
                }
                String id = ((MapConfigLike.Holder)map.get("uniqueIdentifier")).value().toString();
                InlineSerializer serializer = (InlineSerializer)registry.get(id);
                if (serializer == null) {
                    throw new SerializerOptionsException(SerializeData.this.serializer, registry.getKey(), registry.getOptions(), id, this.getLocation());
                }
                MapConfigLike temp = new MapConfigLike(map).setDebugInfo(mapLike.getFile(), mapLike.getPath(), mapLike.getFullLine());
                SerializeData nested = new SerializeData(serializer, SerializeData.this.file, null, (ConfigLike)temp);
                returnValue.add((InlineSerializer)serializer.serialize(nested));
            }
            return returnValue;
        }

        @NotNull
        public <T extends InlineSerializer<T>> List<T> getImpliedList(T impliedType) throws SerializerException {
            ConfigLike configLike = SerializeData.this.config;
            if (!(configLike instanceof MapConfigLike)) {
                throw new UnsupportedOperationException("Cannot use registries with " + String.valueOf(SerializeData.this.config));
            }
            MapConfigLike mapLike = (MapConfigLike)configLike;
            if (!SerializeData.this.has(this.relative)) {
                return List.of();
            }
            List<?> list = SerializeData.this.config.getList(SerializeData.this.getPath(this.relative));
            ArrayList<InlineSerializer> returnValue = new ArrayList<InlineSerializer>();
            for (int i = 0; i < list.size(); ++i) {
                MapConfigLike.Holder holder = (MapConfigLike.Holder)list.get(i);
                Object object = holder.value();
                if (!(object instanceof Map)) {
                    throw SerializeData.this.listException(this.relative, i, "Expected an inline serializer like 'sound(sound=ENTITY_GENERIC_EXPLOSION)', but instead got '" + String.valueOf(holder.value()) + "'");
                }
                Map map = (Map)object;
                if (map.containsKey("uniqueIdentifier") && !me.deecaad.core.mechanics.Registry.matches(map.get("uniqueIdentifier").toString(), impliedType.getKeyword())) {
                    throw SerializeData.this.listException(this.relative, i, "Expected a '" + impliedType.getInlineKeyword() + "' but got a '" + String.valueOf(map.get("uniqueIdentifier")) + "'");
                }
                MapConfigLike temp = new MapConfigLike(map).setDebugInfo(mapLike.getFile(), mapLike.getPath(), mapLike.getFullLine());
                SerializeData nested = new SerializeData(impliedType, SerializeData.this.file, null, (ConfigLike)temp);
                returnValue.add((InlineSerializer)impliedType.serialize(nested));
            }
            return returnValue;
        }

        @Nullable
        public <T extends Serializer<T>> T serialize(@NotNull Class<T> serializerClass) throws SerializerException {
            return (T)((Serializer)this.serialize((Serializer)ReflectionUtil.newInstance(serializerClass)));
        }

        @Nullable
        public <T> T serialize(@NotNull Serializer<T> serializer) throws SerializerException {
            boolean isString;
            if (!SerializeData.this.has(this.relative)) {
                return null;
            }
            SerializeData data = new SerializeData(serializer, SerializeData.this, this.relative);
            data.copyMutables(SerializeData.this);
            boolean bl = SerializeData.this.usingStep ? SerializeData.this.pathToConfig.getString(SerializeData.this.getPath(this.relative)) == null : (isString = SerializeData.this.config.isString(SerializeData.this.getPath(this.relative)));
            if (serializer.canUsePathTo() && isString) {
                if (SerializeData.this.usingStep) {
                    throw SerializeData.this.exception(this.relative, "Tried to use doubly nested path-to. This is is not a supported option.");
                }
                String path = SerializeData.this.config.getString(SerializeData.this.getPath(this.relative));
                if (serializer.getKeyword() == null) {
                    throw new SerializerPathToException(serializer, data);
                }
                if (SerializeData.this.pathToConfig == null) {
                    throw new SerializerPathToException(serializer, data);
                }
                Object obj = SerializeData.this.pathToConfig.getObject(path);
                if (obj == null) {
                    throw SerializeData.this.exception(this.relative, "Found an invalid path when using 'Path To' feature", "Path '" + path + "' could not be found. Check for errors above this message.");
                }
                if (!serializer.getClass().isInstance(obj)) {
                    throw SerializeData.this.exception(this.relative, "Found an invalid object when using 'Path To' feature", "Path '" + path + "' pointed to an improper object type.", "Should have been '" + serializer.getClass().getSimpleName() + "', but instead got '" + obj.getClass().getSimpleName() + "'", SerializerException.forValue(obj));
                }
                return (T)serializer.getClass().cast(obj);
            }
            return serializer.serialize(data);
        }
    }
}

