/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.mechanics.Registry;
import me.deecaad.core.utils.SerializerUtil;
import me.deecaad.core.utils.StringUtil;

public class MapConfigLike
implements ConfigLike {
    private final Map<String, Holder> config = new HashMap<String, Holder>();
    private File file;
    private String path;
    private String fullLine;

    public MapConfigLike(Map<String, Holder> config) {
        for (String key : config.keySet()) {
            String noCase = Registry.toKey(key);
            this.config.put(noCase, config.get(key));
        }
    }

    public MapConfigLike setDebugInfo(File file, String path, String fullLine) {
        this.file = file;
        this.path = path;
        this.fullLine = fullLine;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullLine() {
        return this.fullLine;
    }

    @Override
    public boolean contains(String key) {
        return this.config.containsKey(Registry.toKey(key));
    }

    @Override
    public Object get(String key, Object def) {
        return this.config.getOrDefault((Object)Registry.toKey((String)key), (Holder)new Holder((Object)def, (int)0)).value;
    }

    @Override
    public boolean isString(String key) {
        return this.get(Registry.toKey(key), null) instanceof String;
    }

    @Override
    public List<?> getList(String key) {
        Object temp = this.get(Registry.toKey(key), null);
        if (temp instanceof List) {
            List list = (List)temp;
            return list;
        }
        return List.of();
    }

    @Override
    public String getLocation(File localFile, String localPath) {
        Holder holder = this.config.get(Registry.toKey(localPath));
        if (holder == null) {
            return SerializerUtil.foundAt(this.file, this.path);
        }
        String indent = "    ";
        return SerializerUtil.foundAt(this.file, this.path) + "\n" + indent + this.fullLine + "\n" + StringUtil.repeat(" ", indent.length() + holder.index()) + "^";
    }

    public record Holder(Object value, int index) {
    }
}

