/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.DuplicateKeyException;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.StringUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkedConfig
extends LinkedHashMap<String, Object>
implements Configuration {
    @Override
    public void add(ConfigurationSection config) throws DuplicateKeyException {
        ArrayList<String> duplicates = new ArrayList<String>();
        for (String key : config.getKeys(true)) {
            if (this.containsKey(key)) {
                duplicates.add(key);
            }
            Object value = config.get(key);
            this.set(key, value);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException(duplicates.toArray(new String[0]));
        }
    }

    @Override
    public void add(Configuration config) throws DuplicateKeyException {
        ArrayList duplicates = new ArrayList();
        config.forEach("", (key, value) -> {
            if (this.containsKey((String)key)) {
                duplicates.add(key);
            } else {
                this.set((String)key, value);
            }
        }, true);
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException(duplicates.toArray(new String[0]));
        }
    }

    @Override
    @Nullable
    public Object set(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return super.keySet();
    }

    @Override
    public int getInt(@NotNull String key) {
        Object value = super.get(key);
        if (!(value instanceof Number)) {
            return 0;
        }
        return ((Number)value).intValue();
    }

    @Override
    public int getInt(@NotNull String key, int def) {
        Object value = super.get(key);
        if (!(value instanceof Number)) {
            return def;
        }
        return ((Number)value).intValue();
    }

    @Override
    public double getDouble(@NotNull String key) {
        Object value = super.get(key);
        if (!(value instanceof Number)) {
            return 0.0;
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public double getDouble(@NotNull String key, double def) {
        Object value = super.get(key);
        if (!(value instanceof Number)) {
            return def;
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public boolean getBool(@NotNull String key) {
        Object value = super.get(key);
        if (!(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    @Override
    public boolean getBool(@NotNull String key, boolean def) {
        Object value = super.get(key);
        if (!(value instanceof Boolean)) {
            return def;
        }
        return (Boolean)value;
    }

    @Override
    @NotNull
    public List<String> getList(@NotNull String key) {
        Object value = super.get(key);
        if (!(value instanceof List)) {
            return Collections.emptyList();
        }
        return (List)value;
    }

    @Override
    public List<String> getList(@NotNull String key, List<String> def) {
        Object value = super.get(key);
        if (!(value instanceof List)) {
            return def;
        }
        return (List)value;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        Object value = super.get(key);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    @Override
    public String getString(String key, String def) {
        Object value = super.get(key);
        if (!(value instanceof String)) {
            return def;
        }
        return (String)value;
    }

    @Override
    @Nullable
    public Object getObject(@NotNull String key) {
        return super.get(key);
    }

    @Override
    public Object getObject(@NotNull String key, Object def) {
        return super.getOrDefault(key, def);
    }

    @Override
    @Nullable
    public <T> T getObject(@NotNull String key, @NotNull Class<T> clazz) {
        Object value = super.get(key);
        if (!clazz.isInstance(value)) {
            return null;
        }
        return clazz.cast(value);
    }

    @Override
    public <T> T getObject(@NotNull String key, T def, @NotNull Class<T> clazz) {
        Object value = super.get(key);
        if (!clazz.isInstance(value)) {
            return def;
        }
        return clazz.cast(value);
    }

    @Override
    public boolean containsKey(@NotNull String key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsKey(@NotNull String key, @NotNull Class<?> clazz) {
        return super.containsKey(key) && clazz.isInstance(this.get(key));
    }

    @Override
    public void forEach(@NotNull String basePath, @NotNull BiConsumer<String, Object> consumer, boolean deep) {
        int memorySections = StringUtil.countOccurrences(basePath, '.');
        if (basePath.isEmpty()) {
            --memorySections;
        }
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith(basePath)) continue;
            int currentMemorySections = StringUtil.countOccurrences(key, '.');
            if (!deep && currentMemorySections == memorySections + 1) {
                consumer.accept(key, value);
                continue;
            }
            if (!deep || currentMemorySections <= memorySections) continue;
            consumer.accept(key, value);
        }
    }

    public void save(@NotNull File file) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        try {
            this.add((ConfigurationSection)configuration);
        }
        catch (DuplicateKeyException e) {
            e.printStackTrace();
        }
        configuration.getKeys(true).forEach(arg_0 -> LinkedConfig.lambda$save$1((FileConfiguration)configuration, arg_0));
        this.forEach((arg_0, arg_1) -> ((FileConfiguration)configuration).set(arg_0, arg_1));
        try {
            configuration.save(file);
        }
        catch (IOException ex) {
            MechanicsCore.debug.log(LogLevel.ERROR, "Could not save file \"" + file.getName() + "\"", ex);
        }
    }

    private static /* synthetic */ void lambda$save$1(FileConfiguration configuration, String key) {
        configuration.set(key, null);
    }
}

