/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public class JarSearcher {
    private final JarFile jar;

    public JarSearcher(@NotNull JarFile jar) {
        if (jar == null) {
            throw new IllegalArgumentException("Cannot search a null jar!");
        }
        this.jar = jar;
    }

    public <T> List<Class<T>> findAllSubclasses(@NotNull Class<T> clazz, @NotNull ClassLoader clazzLoader, boolean isIgnoreAbstract, Class<?> ... classes) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        ArrayList classList = new ArrayList(Arrays.asList(classes));
        classList.add(clazz);
        Set blacklist = classList.stream().map(Class::getName).map(str -> str.replaceAll("\\.", "/") + ".class").collect(Collectors.toSet());
        Enumeration<JarEntry> entries = this.jar.entries();
        ArrayList<Class<T>> subclasses = new ArrayList<Class<T>>();
        while (entries.hasMoreElements()) {
            Class<?> subclass;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || blacklist.contains(entryName)) continue;
            String name = entryName.replaceAll("/", "\\.").replace(".class", "");
            try {
                InputStream stream = this.jar.getInputStream(entry);
                byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                int runtimeVersion = 44 + ReflectionUtil.getJavaVersion();
                int classVersion = (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
                if (classVersion > runtimeVersion) {
                    MechanicsCore.debug.debug("Skipping " + name + " because it has class version " + classVersion + "(We are expecting " + runtimeVersion + ")");
                    continue;
                }
                subclass = Class.forName(name, false, clazzLoader);
            }
            catch (Throwable ex) {
                MechanicsCore.debug.log(LogLevel.DEBUG, "Error for class '" + name + "'", ex);
                continue;
            }
            int mod = subclass.getModifiers();
            if (JarSearcherExempt.class.isAssignableFrom(subclass) || !clazz.isAssignableFrom(subclass) || isIgnoreAbstract && (Modifier.isAbstract(mod) || Modifier.isInterface(mod))) continue;
            subclasses.add(subclass);
        }
        return subclasses;
    }
}

